/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.nio.channels.Selector;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class NioServletOutputStream
extends AbstractServletOutputStream {
    private final NioChannel channel;
    private final NioSelectorPool pool;
    private final int maxWrite;

    public NioServletOutputStream(SocketWrapper<NioChannel> socketWrapper, int n, NioSelectorPool nioSelectorPool) {
        super(n);
        this.channel = socketWrapper.getSocket();
        this.pool = nioSelectorPool;
        this.maxWrite = this.channel.getBufHandler().getWriteBuffer().capacity();
    }

    @Override
    protected int doWrite(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = n;
        for (int i = n2; i > 0; i -= n3) {
            int n6 = i > this.maxWrite ? this.maxWrite : i;
            n3 = this.doWriteInternal(bl, byArray, n5, n6);
            n4 += n3;
            n5 += n3;
            if (n3 >= n6) continue;
            break;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWriteInternal(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        this.channel.getBufHandler().getWriteBuffer().clear();
        this.channel.getBufHandler().getWriteBuffer().put(byArray, n, n2);
        this.channel.getBufHandler().getWriteBuffer().flip();
        int n3 = 0;
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.channel.getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        long l = keyAttachment.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            n3 = this.pool.write(this.channel.getBufHandler().getWriteBuffer(), this.channel, selector, l, bl);
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        if (n3 < n2) {
            this.channel.getPoller().add(this.channel, 4);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlush() throws IOException {
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.channel.getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        long l = keyAttachment.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            while (!this.channel.flush(true, selector, l)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.channel.close(true);
    }
}

