/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.external.ClipboardUpdate;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Units;

public class ClipboardUpdateTask
extends UndoableBackgroundTask<ImageInfo> {
    private List<ClipboardUpdate> clipboardUpdates;
    private List<ImageInfo> images;

    public ClipboardUpdateTask(String name, List<ClipboardUpdate> clipboardUpdates, List<ImageInfo> images) {
        super(null, name);
        this.clipboardUpdates = clipboardUpdates;
        this.images = images;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return this.images.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        ClipboardUpdate clipboardUpdate = this.clipboardUpdates.get(this.clipboardUpdates.size() - 1);
        for (ImageInfo imageInfo : this.images) {
            new UpdateGPSLatitude(imageInfo, new Double(clipboardUpdate.getLatitude()).toString(), ImageInfo.DATA_SOURCE.CLIPBOARD);
            new UpdateGPSLongitude(imageInfo, new Double(clipboardUpdate.getLongitude()).toString(), ImageInfo.DATA_SOURCE.CLIPBOARD);
            if (imageInfo.getGpsAltitude() == null) {
                new UpdateGPSAltitude(imageInfo, new Double(0.0).toString(), ImageInfo.DATA_SOURCE.CLIPBOARD, Units.ALTITUDE.METRES);
            }
            this.publish(imageInfo);
        }
        return this.getPresentationName();
    }
}

