import { Capi } from '@tencent-sdk/capi';
import { PascalCasedPropertiesDeep, CamelCasedPropertiesDeep } from 'type-fest';
import { ServiceType } from './constants';
export * from './constants';
export * from './error';
/**
 * simple deep clone object
 * @param {object} obj object
 */
export declare function deepClone<T>(obj: T): T;
/**
 * return variable real type
 * @param {any} obj input variable
 */
export declare function getRealType<T>(obj: T): string;
/**
 * is array
 * @param obj object
 */
export declare function isArray<T>(obj: T[] | T): obj is T[];
/**
 * is object
 * @param obj object
 */
export declare function isObject<T>(obj: T): obj is T;
export declare function isEmpty<T>(val: T): boolean;
export declare function cleanEmptyValue<T>(obj: T): T;
interface ApiFactoryOptions<ACTIONS_T> {
    serviceType: ServiceType;
    version: string;
    actions: ACTIONS_T;
    debug?: boolean;
    isV3?: boolean;
    host?: string;
    path?: string;
    requestClient?: string;
    customHandler?: (action: string, res: any) => any;
    responseHandler?: (res: any) => any;
    errorHandler?: (action: string, res: any) => any;
}
export declare function ApiFactory<ACTIONS_T extends readonly string[]>({ debug, isV3, actions, serviceType, host, path, version, customHandler, responseHandler, errorHandler, requestClient, }: ApiFactoryOptions<ACTIONS_T>): Record<ACTIONS_T[number], (capi: Capi, inputs: any) => any>;
export declare function camelCaseProps<T>(obj: T, pascalCase?: boolean): CamelCasedPropertiesDeep<T> | PascalCasedPropertiesDeep<T>;
export declare function pascalCaseProps<T>(obj: T): PascalCasedPropertiesDeep<T>;
//# sourceMappingURL=index.d.ts.map