/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.utils.FileHash;
import cc.arduino.utils.MultiStepProgress;
import cc.arduino.utils.Progress;
import cc.arduino.utils.network.FileDownloader;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;

public class DownloadableContributionsDownloader {
    private static Logger log = LogManager.getLogger(DownloadableContributionsDownloader.class);
    private final File stagingFolder;

    public DownloadableContributionsDownloader(File _stagingFolder) {
        this.stagingFolder = _stagingFolder;
    }

    public File download(DownloadableContribution contribution, Progress progress, String statusText, ProgressListener progressListener, boolean allowCache) throws Exception {
        return this.download(contribution, progress, statusText, progressListener, false, allowCache);
    }

    public File download(DownloadableContribution contribution, Progress progress, String statusText, ProgressListener progressListener, boolean noResume, boolean allowCache) throws Exception {
        Path outputFile;
        block4: {
            URL url = new URL(contribution.getUrl());
            String filename = new File(contribution.getArchiveFileName()).getName();
            outputFile = Paths.get(this.stagingFolder.getAbsolutePath(), filename).normalize();
            if (outputFile.toFile().isDirectory()) {
                throw new Exception(I18n.format("Can't download {0}: invalid filename or exinsting directory", contribution.getArchiveFileName()));
            }
            Files.createDirectories(this.stagingFolder.toPath(), new FileAttribute[0]);
            if (!this.hasChecksum(contribution) && Files.exists(outputFile, new LinkOption[0])) {
                Files.delete(outputFile);
            }
            boolean downloaded = false;
            while (true) {
                if (!Files.isRegularFile(outputFile, LinkOption.NOFOLLOW_LINKS) || Files.size(outputFile) < contribution.getSize()) {
                    this.download(url, outputFile.toFile(), progress, statusText, progressListener, noResume, allowCache);
                    downloaded = true;
                }
                progress.setStatus(I18n.tr("Verifying archive integrity..."));
                progressListener.onProgress(progress);
                if (!this.hasChecksum(contribution)) break block4;
                String checksum = contribution.getChecksum();
                String algo = checksum.split(":")[0];
                String crc = FileHash.hash(outputFile.toFile(), algo);
                if (crc.equalsIgnoreCase(checksum)) break block4;
                if (downloaded) break;
                Files.delete(outputFile);
                downloaded = true;
            }
            throw new Exception(I18n.tr("CRC doesn't match, file is corrupted. It may be a temporary problem, please retry later."));
        }
        contribution.setDownloaded(true);
        contribution.setDownloadedFile(outputFile.toFile());
        return outputFile.toFile();
    }

    private boolean hasChecksum(DownloadableContribution contribution) {
        String checksum = contribution.getChecksum();
        if (checksum == null || checksum.isEmpty()) {
            return false;
        }
        String algo = checksum.split(":")[0];
        return algo != null && !algo.isEmpty();
    }

    public void download(URL url, File tmpFile, Progress progress, String statusText, ProgressListener progressListener, boolean allowCache) throws Exception {
        this.download(url, tmpFile, progress, statusText, progressListener, false, allowCache);
    }

    public void download(URL url, File tmpFile, Progress progress, String statusText, ProgressListener progressListener, boolean noResume, boolean allowCache) throws Exception {
        FileDownloader downloader = new FileDownloader(url, tmpFile, allowCache);
        downloader.addObserver((o, arg) -> {
            FileDownloader me = (FileDownloader)o;
            String msg = "";
            if (me.getDownloadSize() != null) {
                long downloaded = (me.getInitialSize() + me.getDownloaded()) / 1000L;
                long total = (me.getInitialSize() + me.getDownloadSize()) / 1000L;
                msg = I18n.format(I18n.tr("Downloaded {0}kb of {1}kb."), downloaded, total);
            }
            progress.setStatus(statusText + " " + msg);
            progress.setProgress(me.getProgress());
            progressListener.onProgress(progress);
        });
        downloader.download(noResume);
        if (!downloader.isCompleted()) {
            throw new Exception(I18n.format(I18n.tr("Error downloading {0}"), url), downloader.getError());
        }
    }

    public void downloadIndexAndSignature(MultiStepProgress progress, URL packageIndexUrl, ProgressListener progressListener, SignatureVerifier signatureVerifier) throws Exception {
        String indexFileName = FilenameUtils.getName((String)packageIndexUrl.getPath());
        File packageIndex = BaseNoGui.indexer.getIndexFile(indexFileName);
        String statusText = I18n.tr("Downloading platforms index...");
        File packageIndexTemp = File.createTempFile(indexFileName, ".tmp");
        try {
            this.download(packageIndexUrl, packageIndexTemp, progress, statusText, progressListener, true, true);
            URL signatureUrl = new URL(packageIndexUrl.toString() + ".sig");
            if (this.verifyDomain(packageIndexUrl)) {
                if (this.checkSignature(progress, signatureUrl, progressListener, signatureVerifier, statusText, packageIndexTemp)) {
                    Files.move(packageIndexTemp.toPath(), packageIndex.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    log.info("The cached files have been removed. {} {}", (Object)packageIndexUrl, (Object)signatureUrl);
                    FileDownloader.invalidateFiles(packageIndexUrl, signatureUrl);
                }
            } else {
                Files.move(packageIndexTemp.toPath(), packageIndex.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.info("The domain is not selected to verify the signature. will be copied into this path {}, packageIndex url: {}", (Object)packageIndex, (Object)packageIndexUrl);
            }
        }
        catch (Exception e) {
            log.error("Cannot download the package index from {} the package will be discard", (Object)packageIndexUrl, (Object)e);
            throw e;
        }
        finally {
            Files.deleteIfExists(packageIndexTemp.toPath());
        }
    }

    public boolean verifyDomain(URL url) {
        Collection<String> domain = PreferencesData.getCollection("http.signature_verify_domains");
        if (domain.size() == 0) {
            domain.add("downloads.arduino.cc");
        }
        if (domain.contains(url.getHost())) {
            return true;
        }
        log.info("The domain is not selected to verify the signature. domain list: {}, url: {}", domain, (Object)url);
        return false;
    }

    public boolean checkSignature(MultiStepProgress progress, URL signatureUrl, ProgressListener progressListener, SignatureVerifier signatureVerifier, String statusText, File fileToVerify) throws Exception {
        String signatureFileName = FilenameUtils.getName((String)signatureUrl.getPath());
        File packageIndexSignature = BaseNoGui.indexer.getIndexFile(signatureFileName);
        File packageIndexSignatureTemp = File.createTempFile(signatureFileName, ".tmp");
        try {
            this.download(signatureUrl, packageIndexSignatureTemp, progress, statusText, progressListener, true);
            if (PreferencesData.areInsecurePackagesAllowed()) {
                Files.move(packageIndexSignatureTemp.toPath(), packageIndexSignature.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.info("Allowing insecure packages because allow_insecure_packages is set to true in preferences.txt but the signature was download");
                boolean bl = true;
                return bl;
            }
            boolean signatureVerified = signatureVerifier.isSigned(fileToVerify, packageIndexSignatureTemp);
            if (signatureVerified) {
                log.info("Signature verified. url={}, signature url={}, file to verify={}, signature file={}", (Object)signatureUrl, (Object)signatureUrl, (Object)fileToVerify, (Object)packageIndexSignatureTemp);
                Files.move(packageIndexSignatureTemp.toPath(), packageIndexSignature.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                log.error("{} file signature verification failed. File ignored.", (Object)signatureUrl);
                System.err.println(I18n.format(I18n.tr("{0} file signature verification failed. File ignored."), signatureUrl.toString()));
            }
            boolean bl = signatureVerified;
            return bl;
        }
        catch (Exception e) {
            log.error("Cannot download the signature from {} the package will be discard", (Object)signatureUrl, (Object)e);
            throw e;
        }
        finally {
            Files.deleteIfExists(packageIndexSignatureTemp.toPath());
        }
    }
}

