/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

abstract class CommandChangeState
extends SingleLineCommand2<TimingDiagram> {
    static final String STATE_CODE = "([\\p{L}0-9_][\\p{L}0-9_.]*)";

    CommandChangeState(IRegex pattern) {
        super(pattern);
    }

    static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    protected CommandExecutionResult addState(TimingDiagram diagram, RegexResult arg, Player player, TimeTick now) throws NoSuchColorException {
        String comment = arg.get("COMMENT", 0);
        Colors colors = CommandChangeState.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        player.setState(now, comment, colors, this.getStates(arg));
        return CommandExecutionResult.ok();
    }

    private String[] getStates(RegexResult arg) {
        if (arg.get("STATE7", 0) != null) {
            String state1 = arg.get("STATE7", 0);
            String state2 = arg.get("STATE7", 1);
            return new String[]{state1, state2};
        }
        return new String[]{arg.getLazzy("STATE", 0)};
    }

    static IRegex getStateOrHidden() {
        return new RegexOr(new RegexLeaf("STATE1", "[%g]([^%g]*)[%g]"), new RegexLeaf("STATE2", STATE_CODE), new RegexLeaf("STATE3", "(\\{hidden\\})"), new RegexLeaf("STATE4", "(\\{\\.\\.\\.\\})"), new RegexLeaf("STATE5", "(\\{-\\})"), new RegexLeaf("STATE6", "(\\{\\?\\})"), new RegexLeaf("STATE7", "(?:\\{([\\p{L}0-9_][\\p{L}0-9_.]*),([\\p{L}0-9_][\\p{L}0-9_.]*)\\})"));
    }
}

