
#ifndef KDEGAMES_EXPORT_H
#define KDEGAMES_EXPORT_H

#ifdef KDEGAMES_STATIC_DEFINE
#  define KDEGAMES_EXPORT
#  define KDEGAMES_NO_EXPORT
#else
#  ifndef KDEGAMES_EXPORT
#    ifdef KF5KDEGames_EXPORTS
        /* We are building this library */
#      define KDEGAMES_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDEGAMES_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDEGAMES_NO_EXPORT
#    define KDEGAMES_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDEGAMES_DECL_DEPRECATED
#  define KDEGAMES_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDEGAMES_DECL_DEPRECATED_EXPORT
#  define KDEGAMES_DECL_DEPRECATED_EXPORT KDEGAMES_EXPORT KDEGAMES_DECL_DEPRECATED
#endif

#ifndef KDEGAMES_DECL_DEPRECATED_NO_EXPORT
#  define KDEGAMES_DECL_DEPRECATED_NO_EXPORT KDEGAMES_NO_EXPORT KDEGAMES_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDEGAMES_NO_DEPRECATED
#    define KDEGAMES_NO_DEPRECATED
#  endif
#endif

#define KDEGAMES_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KDEGAMES_NO_DEPRECATED)
#  undef KDEGAMES_DEPRECATED
#  define KDEGAMES_DEPRECATED_EXPORT KDEGAMES_EXPORT
#  define KDEGAMES_DEPRECATED_NO_EXPORT KDEGAMES_NO_EXPORT
#elif defined(KDEGAMES_NO_DEPRECATED_WARNINGS)
#  define KDEGAMES_DEPRECATED
#  define KDEGAMES_DEPRECATED_EXPORT KDEGAMES_EXPORT
#  define KDEGAMES_DEPRECATED_NO_EXPORT KDEGAMES_NO_EXPORT
#else
#  define KDEGAMES_DEPRECATED KDEGAMES_DECL_DEPRECATED
#  define KDEGAMES_DEPRECATED_EXPORT KDEGAMES_DECL_DEPRECATED_EXPORT
#  define KDEGAMES_DEPRECATED_NO_EXPORT KDEGAMES_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDEGAMES_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDEGAMES_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDEGAMES_NO_DEPRECATED
#  define KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT 0x70300
#endif
#ifdef KDEGAMES_NO_DEPRECATED_WARNINGS
#  define KDEGAMES_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDEGAMES_DEPRECATED_WARNINGS_SINCE
#  ifdef KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDEGAMES_DEPRECATED_WARNINGS_SINCE KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDEGAMES_DEPRECATED_WARNINGS_SINCE 0x70300
#  endif
#endif

#ifndef KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDEGAMES_DEPRECATED
#  define KDEGAMES_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDEGAMES_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDEGAMES_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDEGAMES_DEPRECATED_WARNINGS_SINCE >= 0x40100
#  define KDEGAMES_DEPRECATED_VERSION_4_1(text) KDEGAMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KDEGAMES_DEPRECATED_VERSION_4_1(text)
#endif
#define KDEGAMES_DEPRECATED_VERSION_4(minor, text)      KDEGAMES_DEPRECATED_VERSION_4_##minor(text)
#define KDEGAMES_DEPRECATED_VERSION(major, minor, text) KDEGAMES_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDEGAMES_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDEGAMES_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDEGAMES_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDEGAMES_DEPRECATED_VERSION(major, minor, text)
#  define KDEGAMES_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDEGAMES_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDEGAMES_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDEGAMES_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KDEGAMES_EXPORT_H */
