/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hsb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "centralnoafriski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskowski standardny \u010das",
               "",
               "Moskowski l\u011btni \u010das",
               "",
               "Moskowski \u010das",
               "",
            };
        final String[] Japan = new String[] {
               "japanski standardny \u010das",
               "",
               "japanski l\u011btni \u010das",
               "",
               "japanski \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistanski standardny \u010das",
               "",
               "pakistanski l\u011btni \u010das",
               "",
               "pakistanski \u010das",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipehski standardny \u010das",
               "",
               "Taipehski l\u011btni \u010das",
               "",
               "Taipehski \u010das",
               "",
            };
        final String[] Hovd = new String[] {
               "Chowdski standardny \u010das",
               "",
               "Chowdski l\u011btni \u010das",
               "",
               "Chowdski \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanski standardny \u010das",
               "",
               "Magadanski l\u011btni \u010das",
               "",
               "Magadanski \u010das",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "srjed\u017aozapadny awstralski standardny \u010das",
               "",
               "sjed\u017aozapadny awstralski l\u011btni \u010das",
               "",
               "srjed\u017aozapadny awstralski \u010das",
               "",
            };
        final String[] Europe_Central = new String[] {
               "srjed\u017aoeuropski standardny \u010das",
               "MEZ",
               "srjed\u017aoeuropski l\u011btni \u010das",
               "MESZ",
               "srjed\u017aoeuropski \u010das",
               "MEZ",
            };
        final String[] Sakhalin = new String[] {
               "sachalinski standardny \u010das",
               "",
               "sachalinski l\u011btni \u010das",
               "",
               "sachalinski \u010das",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayski standardny \u010das",
               "",
               "Paraguayski l\u011btni \u010das",
               "",
               "Paraguayski \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajziski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "sewjeroameriski wuchodny standardny \u010das",
               "",
               "sewjeroameriski wuchodny l\u011btni \u010das",
               "",
               "sewjeroameriski wuchodny \u010das",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "standardny \u010das kupy Lord-Howe",
               "",
               "l\u011btni \u010das kupy Lord-Howe",
               "",
               "\u010das kupy Lord-Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "nowoseelandski standardny \u010das",
               "",
               "nowoseelandski l\u011btni \u010das",
               "",
               "nowoseelandski \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indiskooceanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardny \u010das",
               "",
               "Jakutski l\u011btni \u010das",
               "",
               "Jakutski \u010das",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritiuski standardny \u010das",
               "",
               "mauritiuski l\u011btni \u010das",
               "",
               "mauritiuski \u010das",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "wuchodoafriski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "wuchodnotimorski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010das Salomonskich kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "kosraeski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "wuchodoeuropski standardny \u010das",
               "OEZ",
               "wuchodoeuropski l\u011btni \u010das",
               "OESZ",
               "wuchodoeuropski \u010das",
               "OEZ",
            };
        final String[] Newfoundland = new String[] {
               "nowofundlandski standardny \u010das",
               "",
               "nowofundlandski l\u011btni \u010das",
               "",
               "nowofundlandski \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afghanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongski standardny \u010das",
               "",
               "Hongkongski l\u011btni \u010das",
               "",
               "Hongkongski \u010das",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "zapadoargentinski standardny \u010das",
               "",
               "zapadoargentinski l\u011btni \u010das",
               "",
               "zapadoargentinski \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantiski standardny \u010das",
               "",
               "atlantiski l\u011btni \u010das",
               "",
               "atlantiski \u010das",
               "",
            };
        final String[] Ponape = new String[] {
               "ponapeski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "boliwiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "standardny \u010das kupow St. Pierre a Miquelon",
               "",
               "l\u011btni \u010das kupow St. Pierre a Miquelon",
               "",
               "\u010das kupow St. Pierre a Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "indochinski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgski standardny \u010das",
               "",
               "Jekaterinburgski l\u011btni \u010das",
               "",
               "Jekaterinburgski \u010das",
               "",
            };
        final String[] Maldives = new String[] {
               "malediwski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "israelski standardny \u010das",
               "",
               "israelski l\u011btni \u010das",
               "",
               "israelski \u010das",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "srjed\u017aoindoneski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010das kupow Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "ju\u017enoafriski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowaski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Linijowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekski standardny \u010das",
               "",
               "uzbekski l\u011btni \u010das",
               "",
               "uzbekski \u010das",
               "",
            };
        final String[] Omsk = new String[] {
               "Omski standardny \u010das",
               "",
               "Omski l\u011btni \u010das",
               "",
               "Omski \u010das",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychellski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayski standardny \u010das",
               "",
               "uruguayski l\u011btni \u010das",
               "",
               "uruguayski \u010das",
               "",
            };
        final String[] Nepal = new String[] {
               "nepalski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batorski standardny \u010das",
               "",
               "Ulan-Batorski l\u011btni \u010das",
               "",
               "Ulan-Batorski \u010das",
               "",
            };
        final String[] America_Central = new String[] {
               "sewjeroameriski centralny standardny \u010das",
               "",
               "sewjeroameriski centralny l\u011btni \u010das",
               "",
               "sewjeroameriski centralny \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "chuukski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "niueski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010das kupy Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandski standardny \u010das",
               "",
               "falklandski l\u011btni \u010das",
               "",
               "falklandski \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatuski standardny \u010das",
               "",
               "vanuatuski l\u011btni \u010das",
               "",
               "vanuatuski \u010das",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirski standardny \u010das",
               "",
               "Nowosibirski l\u011btni \u010das",
               "",
               "Nowosibirski \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapurski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "acorski standardny \u010das",
               "",
               "acorski l\u011btni \u010das",
               "",
               "acorski \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "Apiaski standardny \u010das",
               "",
               "Apiaski l\u011btni \u010das",
               "",
               "Apiaski \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhutanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "nauruski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardny \u010das",
               "",
               "Krasnojarski l\u011btni \u010das",
               "",
               "Krasnojarski \u010das",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "zapadnokazachski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "myanmarski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010das Hodowneje kupy",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amaconaski standardny \u010das",
               "",
               "Amaconaski l\u011btni \u010das",
               "",
               "Amaconaski \u010das",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "wuchodnokazachski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "fid\u017aiski standardny \u010das",
               "",
               "fid\u017aiski l\u011btni \u010das",
               "",
               "fid\u017aiski \u010das",
               "",
            };
        final String[] Reunion = new String[] {
               "reunionski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamski standardny \u010das",
               "",
               "chathamski l\u011btni \u010das",
               "",
               "chathamski \u010das",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostokski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentinski standardny \u010das",
               "",
               "argentinski l\u011btni \u010das",
               "",
               "argentinski \u010das",
               "",
            };
        final String[] Gambier = new String[] {
               "gambierski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "tuvaluski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galapagoski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u010das kupy Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaiisko-aleutski standardny \u010das",
               "",
               "hawaiisko-aleutski l\u011btni \u010das",
               "",
               "hawaiisko-aleutski \u010das",
               "",
            };
        final String[] Australia_Central = new String[] {
               "srjed\u017aoawstralski standardny \u010das",
               "",
               "srjed\u017aoawstralski l\u011btni \u010das",
               "",
               "srjed\u017aoawstralski \u010das",
               "",
            };
        final String[] America_Pacific = new String[] {
               "sewjeroameriski pacifiski standardny \u010das",
               "",
               "sewjeroameriski pacifiski l\u011btni \u010das",
               "",
               "sewjeroameriski pacifiski \u010das",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das Phoenixowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "turkmenski standardny \u010das",
               "",
               "turkmenski l\u011btni \u010das",
               "",
               "turkmenski \u010das",
               "",
            };
        final String[] Europe_Western = new String[] {
               "zapadoeuropski standardny \u010das",
               "WEZ",
               "zapadoeuropski l\u011btni \u010das",
               "WESZ",
               "zapadoeuropski \u010das",
               "WEZ",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdski standardny \u010das",
               "",
               "kapverdski l\u011btni \u010das",
               "",
               "kapverdski \u010das",
               "",
            };
        final String[] Norfolk = new String[] {
               "\u010das kupy Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "guyanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotheraski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samoaski standardny \u010das",
               "",
               "samoaski l\u011btni \u010das",
               "",
               "samoaski \u010das",
               "",
            };
        final String[] Palau = new String[] {
               "palauski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017aanski standardny \u010das",
               "",
               "azerbajd\u017aanski l\u011btni \u010das",
               "",
               "azerbajd\u017aanski \u010das",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexiski pacifiski standardny \u010das",
               "",
               "mexiski pacifiski l\u011btni \u010das",
               "",
               "mexiski pacifiski \u010das",
               "",
            };
        final String[] Davis = new String[] {
               "Daviski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "kubaski standardny \u010das",
               "",
               "kubaski l\u011btni \u010das",
               "",
               "kubaski \u010das",
               "",
            };
        final String[] Africa_Western = new String[] {
               "zapadoafriski standardny \u010das",
               "",
               "zapadoafriski l\u011btni \u010das",
               "",
               "zapadoafriski \u010das",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwichski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "filipinski standardny \u010das",
               "",
               "filipinski l\u011btni \u010das",
               "",
               "filipinski \u010das",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u010das Francoskeho ju\u017eneho a antarktiskeho teritorija",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ju\u017enogeorgiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "nowokaledonski standardny \u010das",
               "",
               "nowokaledonski l\u011btni \u010das",
               "",
               "nowokaledonski \u010das",
               "",
            };
        final String[] Brunei = new String[] {
               "bruneiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "iranski standardny \u010das",
               "",
               "iranski l\u011btni \u010das",
               "",
               "iranski \u010das",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "standardny \u010das Jutrowneje kupy",
               "",
               "l\u011btni \u010das Jutrowneje kupy",
               "",
               "\u010das Jutrowneje kupy",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "mexiski sewjerozapadny standardny \u010das",
               "",
               "mexiski sewjerozapadny l\u011btni \u010das",
               "",
               "mexiski sewjerozapadny \u010das",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u00b4 Urvilleski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017aikski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tongaski standardny \u010das",
               "",
               "tongaski l\u011btni \u010das",
               "",
               "tongaski \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglade\u0161ski standardny \u010das",
               "",
               "banglade\u0161ski l\u011btni \u010das",
               "",
               "banglade\u0161ski \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "peruski standardny \u010das",
               "",
               "peruski l\u011btni \u010das",
               "",
               "peruski \u010das",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "zapadogr\u00f6nlandski standardny \u010das",
               "",
               "zapadogr\u00f6nlandski l\u011btni \u010das",
               "",
               "zapadogr\u00f6nlandski \u010das",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekwadorski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "wuchodogr\u00f6nlandski standardny \u010das",
               "",
               "wuchodogr\u00f6nlandski l\u011btni \u010das",
               "",
               "wuchodogr\u00f6nlandski \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "\u010das Persiskeho golfa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "wuchodoindoneski",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "korejski standardny \u010das",
               "",
               "korejski l\u011btni \u010das",
               "",
               "korejski \u010das",
               "",
            };
        final String[] Australia_Western = new String[] {
               "zapadoawstralski standardny \u010das",
               "",
               "zapadoawstralski l\u011btni \u010das",
               "",
               "zapadoawstralski \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "zapadoindoneski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "wuchodoawstralski standardny \u010das",
               "",
               "wuchodoawstralski l\u011btni \u010das",
               "",
               "wuchodoawstralski \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francoskoguyanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "kolumbiski standardny \u010das",
               "",
               "kolumbiski l\u011btni \u010das",
               "",
               "kolumbiski \u010das",
               "",
            };
        final String[] Chile = new String[] {
               "chilski standardny \u010das",
               "",
               "chilski l\u011btni \u010das",
               "",
               "chilski \u010das",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "sewjeroameriski h\u00f3rski standardny \u010das",
               "",
               "sewjeroameriski h\u00f3rski l\u011btni \u010das",
               "",
               "sewjeroameriski h\u00f3rski \u010das",
               "",
            };
        final String[] Marquesas = new String[] {
               "marquesaski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabski standardny \u010das",
               "",
               "arabski l\u011btni \u010das",
               "",
               "arabski \u010das",
               "",
            };
        final String[] Alaska = new String[] {
               "alaskaski standardny \u010das",
               "",
               "alaskaski l\u011btni \u010das",
               "",
               "alaskaski \u010das",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostokski standardny \u010das",
               "",
               "Wladiwostokski l\u011btni \u010das",
               "",
               "Wladiwostokski \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorroski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardny \u010das",
               "",
               "Irkutski l\u011btni \u010das",
               "",
               "Irkutski \u010das",
               "",
            };
        final String[] Georgia = new String[] {
               "georgiski standardny \u010das",
               "",
               "georgiski l\u011btni \u010das",
               "",
               "georgiski \u010das",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelauski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "papua-nowoginejski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "standardny \u010das kupow Fernando de Noronha",
               "",
               "l\u011btni \u010das kupow Fernando de Noronha",
               "",
               "\u010das kupow Fernando de Noronha",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsanski standardny \u010das",
               "",
               "\u010cojbalsanski l\u011btni \u010das",
               "",
               "\u010cojbalsanski \u010das",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasiliski standardny \u010das",
               "",
               "Brasiliski l\u011btni \u010das",
               "",
               "Brasiliski \u010das",
               "",
            };
        final String[] China = new String[] {
               "chinski standardny \u010das",
               "",
               "chinski l\u011btni \u010das",
               "",
               "chinski \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "armenski standardny \u010das",
               "",
               "armenski l\u011btni \u010das",
               "",
               "armenski \u010das",
               "",
            };
        final String[] India = new String[] {
               "indiski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "standardny \u010das Cookowych kupow",
               "",
               "l\u011btni \u010das Cookowych kupow",
               "",
               "\u010das Cookowych kupow",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwichski \u010das",
                    "",
                    "Britiski l\u011btni \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Antarktika/Wostok" },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Sewjerna Dakota" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ai" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "D\u017aibuti" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Jutrowna kupa" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "Kanariske kupy" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Jerjewan" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "timezone.excity.Europe/Warsaw", "War\u0161awa" },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznjeck" },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Sewjerna Dakota" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont D\u2019Urville" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017ena Georgiska" },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havanna" },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Asia/Pyongyang", "Pj\u00f6ngjang" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Sewjerna Dakota" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "njeznate" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "America/Yakutat", Alaska },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daressalam" },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minhowe m\u011bsto" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichski \u010das",
                    "",
                    "Irski l\u011btni \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Belgrade", "B\u011b\u0142ohr\u00f3d" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "Mexiko m\u011bsto" },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zapori\u017e\u017eja" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.Asia/Jayapura", "Port Numbay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskwa" },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichski \u010das",
                    "",
                    "Britiski l\u011btni \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "St.Barth\u00e9lemy" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kaimanske kupy" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4r\u00f6ske kupy" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Acory" },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Hodowna kupa" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injow" },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.Indian/Maldives", "Malediwy" },
        };
        return data;
    }
}
