/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;

public class SSLAuthenticator
extends AuthenticatorBase {
    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (this.checkForCachedAuthentication(request, httpServletResponse, false)) {
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Looking up certificates");
        }
        if ((x509CertificateArray = this.getRequestCertificates(request)) == null || x509CertificateArray.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  No certificates included with this request");
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.certificates"));
            return false;
        }
        Principal principal = this.context.getRealm().authenticate(x509CertificateArray);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  Realm.authenticate() returned false");
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, httpServletResponse, principal, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

