/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.ManagedDataSource;
import org.apache.tomcat.dbcp.dbcp2.managed.PoolableManagedConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;
import org.apache.tomcat.dbcp.dbcp2.managed.XAConnectionFactory;

public class BasicManagedDataSource
extends BasicDataSource {
    private TransactionRegistry transactionRegistry;
    private transient TransactionManager transactionManager;
    private String xaDataSource;
    private XADataSource xaDataSourceInstance;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public synchronized XADataSource getXaDataSourceInstance() {
        return this.xaDataSourceInstance;
    }

    public synchronized void setXaDataSourceInstance(XADataSource xADataSource) {
        this.xaDataSourceInstance = xADataSource;
        this.xaDataSource = xADataSource == null ? null : xADataSource.getClass().getName();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    protected synchronized TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public synchronized String getXADataSource() {
        return this.xaDataSource;
    }

    public synchronized void setXADataSource(String string) {
        this.xaDataSource = string;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        Object object;
        if (this.transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (this.xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory localXAConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), this.getTransactionSynchronizationRegistry(), connectionFactory);
            this.transactionRegistry = localXAConnectionFactory.getTransactionRegistry();
            return localXAConnectionFactory;
        }
        if (this.xaDataSourceInstance == null) {
            object = null;
            try {
                object = Class.forName(this.xaDataSource);
            }
            catch (Exception exception) {
                String string = "Cannot load XA data source class '" + this.xaDataSource + "'";
                throw new SQLException(string, exception);
            }
            try {
                this.xaDataSourceInstance = (XADataSource)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                String string = "Cannot create XA data source of class '" + this.xaDataSource + "'";
                throw new SQLException(string, exception);
            }
        }
        object = new DataSourceXAConnectionFactory(this.getTransactionManager(), this.xaDataSourceInstance, this.getUsername(), Utils.toCharArray(this.getPassword()), this.getTransactionSynchronizationRegistry());
        this.transactionRegistry = object.getTransactionRegistry();
        return object;
    }

    @Override
    protected DataSource createDataSourceInstance() throws SQLException {
        ManagedDataSource<PoolableConnection> managedDataSource = new ManagedDataSource<PoolableConnection>(this.getConnectionPool(), this.transactionRegistry);
        managedDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return managedDataSource;
    }

    @Override
    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory connectionFactory) throws SQLException {
        PoolableManagedConnectionFactory poolableManagedConnectionFactory = null;
        try {
            poolableManagedConnectionFactory = new PoolableManagedConnectionFactory((XAConnectionFactory)connectionFactory, this.getRegisteredJmxName());
            poolableManagedConnectionFactory.setValidationQuery(this.getValidationQuery());
            poolableManagedConnectionFactory.setValidationQueryTimeout(this.getValidationQueryTimeout());
            poolableManagedConnectionFactory.setConnectionInitSql(this.getConnectionInitSqls());
            poolableManagedConnectionFactory.setDefaultReadOnly(this.getDefaultReadOnly());
            poolableManagedConnectionFactory.setDefaultAutoCommit(this.getDefaultAutoCommit());
            poolableManagedConnectionFactory.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
            poolableManagedConnectionFactory.setDefaultCatalog(this.getDefaultCatalog());
            poolableManagedConnectionFactory.setDefaultSchema(this.getDefaultSchema());
            poolableManagedConnectionFactory.setCacheState(this.getCacheState());
            poolableManagedConnectionFactory.setPoolStatements(this.isPoolPreparedStatements());
            poolableManagedConnectionFactory.setClearStatementPoolOnReturn(this.isClearStatementPoolOnReturn());
            poolableManagedConnectionFactory.setMaxOpenPreparedStatements(this.getMaxOpenPreparedStatements());
            poolableManagedConnectionFactory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
            poolableManagedConnectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            poolableManagedConnectionFactory.setAutoCommitOnReturn(this.getAutoCommitOnReturn());
            poolableManagedConnectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeout());
            poolableManagedConnectionFactory.setFastFailValidation(this.getFastFailValidation());
            poolableManagedConnectionFactory.setDisconnectionSqlCodes(this.getDisconnectionSqlCodes());
            BasicManagedDataSource.validateConnectionFactory(poolableManagedConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
        return poolableManagedConnectionFactory;
    }
}

