/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.res.StringManager;

public class IdentityInputFilter
implements InputFilter {
    private static final StringManager sm = StringManager.getManager((String)IdentityInputFilter.class.getPackage().getName());
    protected static final String ENCODING_NAME = "identity";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected InputBuffer buffer;
    protected ByteChunk endChunk = new ByteChunk();
    private final int maxSwallowSize;

    @Deprecated
    public long getContentLength() {
        return this.contentLength;
    }

    @Deprecated
    public long getRemaining() {
        return this.remaining;
    }

    public IdentityInputFilter(int n) {
        this.maxSwallowSize = n;
    }

    @Override
    public int doRead(ByteChunk byteChunk, Request request) throws IOException {
        int n = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                int n2 = this.buffer.doRead(byteChunk, request);
                if ((long)n2 > this.remaining) {
                    byteChunk.setBytes(byteChunk.getBytes(), byteChunk.getStart(), (int)this.remaining);
                    n = (int)this.remaining;
                } else {
                    n = n2;
                }
                if (n2 > 0) {
                    this.remaining -= (long)n2;
                }
            } else {
                byteChunk.recycle();
                n = -1;
            }
        }
        return n;
    }

    @Override
    public void setRequest(Request request) {
        this.remaining = this.contentLength = request.getContentLengthLong();
    }

    @Override
    public long end() throws IOException {
        boolean bl = this.maxSwallowSize > -1 && this.remaining > (long)this.maxSwallowSize;
        long l = 0L;
        while (this.remaining > 0L) {
            int n = this.buffer.doRead(this.endChunk, null);
            if (n > 0) {
                this.remaining -= (long)n;
                if (!bl || (l += (long)n) <= (long)this.maxSwallowSize) continue;
                throw new IOException(sm.getString("inputFilter.maxSwallow"));
            }
            this.remaining = 0L;
        }
        return -this.remaining;
    }

    @Override
    public int available() {
        return this.buffer.available();
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
        this.endChunk.recycle();
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(Charset.defaultCharset()), 0, ENCODING_NAME.length());
    }
}

