/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.WeakHashMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLSessionManager;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.res.StringManager;

class JSSESupport
implements SSLSupport,
SSLSessionManager {
    private static final Log log = LogFactory.getLog(JSSESupport.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.jsse.res");
    private static final Map<SSLSession, Integer> keySizeCache = new WeakHashMap<SSLSession, Integer>();
    protected SSLSocket ssl;
    protected SSLSession session;
    Listener listener = new Listener();

    JSSESupport(SSLSocket sSLSocket) {
        this.ssl = sSLSocket;
        this.session = sSLSocket.getSession();
        sSLSocket.addHandshakeCompletedListener(this.listener);
    }

    JSSESupport(SSLSession sSLSession) {
        this.session = sSLSession;
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    protected X509Certificate[] getX509Certificates(SSLSession sSLSession) {
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (Throwable throwable) {
            log.debug((Object)sm.getString("jsseSupport.clientCertError"), throwable);
            return null;
        }
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i] instanceof X509Certificate) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            } else {
                try {
                    byte[] byArray = certificateArray[i].getEncoded();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    x509CertificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                }
                catch (Exception exception) {
                    log.info((Object)sm.getString("jseeSupport.certTranslationError", new Object[]{certificateArray[i]}), (Throwable)exception);
                    return null;
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Cert #" + i + " = " + x509CertificateArray[i]));
        }
        if (x509CertificateArray.length < 1) {
            return null;
        }
        return x509CertificateArray;
    }

    @Override
    public Object[] getPeerCertificateChain(boolean bl) throws IOException {
        if (this.session == null) {
            return null;
        }
        Object[] objectArray = null;
        try {
            objectArray = this.session.getPeerCertificates();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length <= 0 && bl && this.ssl != null) {
            this.session.invalidate();
            this.handShake();
            this.session = this.ssl.getSession();
        }
        return this.getX509Certificates(this.session);
    }

    protected void handShake() throws IOException {
        if (this.ssl.getWantClientAuth()) {
            log.debug((Object)sm.getString("jsseSupport.noCertWant"));
        } else {
            this.ssl.setNeedClientAuth(true);
        }
        if (this.ssl.getEnabledCipherSuites().length == 0) {
            log.warn((Object)sm.getString("jsseSupport.serverRenegDisabled"));
            this.session.invalidate();
            this.ssl.close();
            return;
        }
        InputStream inputStream = this.ssl.getInputStream();
        int n = this.ssl.getSoTimeout();
        this.ssl.setSoTimeout(1000);
        byte[] byArray = new byte[1];
        this.listener.reset();
        this.ssl.startHandshake();
        int n2 = 60;
        for (int i = 0; i < n2; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Reading for try #" + i));
            }
            try {
                int n3 = inputStream.read(byArray);
                if (n3 > 0) {
                    throw new SSLException(sm.getString("jsseSupport.unexpectedData"));
                }
            }
            catch (SSLException sSLException) {
                log.info((Object)sm.getString("jsseSupport.clientCertError"), (Throwable)sSLException);
                throw sSLException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.listener.completed) break;
        }
        this.ssl.setSoTimeout(n);
        if (!this.listener.completed) {
            throw new SocketException("SSL Cert handshake timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getKeySize() throws IOException {
        SSLSupport.CipherData[] cipherDataArray = ciphers;
        if (this.session == null) {
            return null;
        }
        Integer n = null;
        Map<SSLSession, Integer> map = keySizeCache;
        synchronized (map) {
            n = keySizeCache.get(this.session);
        }
        if (n == null) {
            int n2 = 0;
            String string = this.session.getCipherSuite();
            for (int i = 0; i < cipherDataArray.length; ++i) {
                if (string.indexOf(cipherDataArray[i].phrase) < 0) continue;
                n2 = cipherDataArray[i].keySize;
                break;
            }
            n = n2;
            Map<SSLSession, Integer> map2 = keySizeCache;
            synchronized (map2) {
                keySizeCache.put(this.session, n);
            }
        }
        return n;
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] byArray = this.session.getId();
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by);
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void invalidateSession() {
        this.session.invalidate();
    }

    @Override
    public String getProtocol() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getProtocol();
    }

    private static class Listener
    implements HandshakeCompletedListener {
        volatile boolean completed = false;

        private Listener() {
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            this.completed = true;
        }

        void reset() {
            this.completed = false;
        }
    }
}

