/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.StopPooledThreadException;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThread;

public class ThreadPoolExecutor
extends java.util.concurrent.ThreadPoolExecutor {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.threads.res");
    private final AtomicInteger submittedCount = new AtomicInteger(0);
    private final AtomicLong lastContextStoppedTime = new AtomicLong(0L);
    private final AtomicLong lastTimeThreadKilledItself = new AtomicLong(0L);
    private long threadRenewalDelay = 1000L;

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, rejectedExecutionHandler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long l) {
        this.threadRenewalDelay = l;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (!(throwable instanceof StopPooledThreadException)) {
            this.submittedCount.decrementAndGet();
        }
        if (throwable == null) {
            this.stopCurrentThreadIfNeeded();
        }
    }

    protected void stopCurrentThreadIfNeeded() {
        long l;
        if (this.currentThreadShouldBeStopped() && (l = this.lastTimeThreadKilledItself.longValue()) + this.threadRenewalDelay < System.currentTimeMillis() && this.lastTimeThreadKilledItself.compareAndSet(l, System.currentTimeMillis() + 1L)) {
            String string = sm.getString("threadPoolExecutor.threadStoppedToAvoidPotentialLeak", new Object[]{Thread.currentThread().getName()});
            throw new StopPooledThreadException(string);
        }
    }

    protected boolean currentThreadShouldBeStopped() {
        TaskThread taskThread;
        return this.threadRenewalDelay >= 0L && Thread.currentThread() instanceof TaskThread && (taskThread = (TaskThread)Thread.currentThread()).getCreationTime() < this.lastContextStoppedTime.longValue();
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable runnable, long l, TimeUnit timeUnit) {
        this.submittedCount.incrementAndGet();
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (super.getQueue() instanceof TaskQueue) {
                TaskQueue taskQueue = (TaskQueue)super.getQueue();
                try {
                    if (!taskQueue.force(runnable, l, timeUnit)) {
                        this.submittedCount.decrementAndGet();
                        throw new RejectedExecutionException(sm.getString("threadPoolExecutor.queueFull"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.submittedCount.decrementAndGet();
                    throw new RejectedExecutionException(interruptedException);
                }
            }
            this.submittedCount.decrementAndGet();
            throw rejectedExecutionException;
        }
    }

    public void contextStopping() {
        TaskQueue taskQueue;
        this.lastContextStoppedTime.set(System.currentTimeMillis());
        int n = this.getCorePoolSize();
        TaskQueue taskQueue2 = taskQueue = this.getQueue() instanceof TaskQueue ? (TaskQueue)this.getQueue() : null;
        if (taskQueue != null) {
            taskQueue.setForcedRemainingCapacity(0);
        }
        this.setCorePoolSize(0);
        if (taskQueue != null) {
            taskQueue.resetForcedRemainingCapacity();
        }
        this.setCorePoolSize(n);
    }

    private static class RejectHandler
    implements RejectedExecutionHandler {
        private RejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }
}

