/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    @Override
    public void jspError(String string, int n, int n2, String string2, Exception exception) throws JasperException {
        throw new JasperException(string + " (" + Localizer.getMessage("jsp.error.location", Integer.toString(n), Integer.toString(n2)) + ") " + string2, exception);
    }

    @Override
    public void jspError(String string, Exception exception) throws JasperException {
        throw new JasperException(string, exception);
    }

    @Override
    public void javacError(JavacErrorDetail[] javacErrorDetailArray) throws JasperException {
        if (javacErrorDetailArray == null) {
            return;
        }
        Object[] objectArray = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (JavacErrorDetail javacErrorDetail : javacErrorDetailArray) {
            if (javacErrorDetail.getJspBeginLineNumber() >= 0) {
                objectArray = new Object[]{javacErrorDetail.getJspBeginLineNumber(), javacErrorDetail.getJspFileName()};
                stringBuilder.append(Constants.NEWLINE);
                stringBuilder.append(Constants.NEWLINE);
                stringBuilder.append(Localizer.getMessage("jsp.error.single.line.number", objectArray));
                stringBuilder.append(Constants.NEWLINE);
                stringBuilder.append(javacErrorDetail.getErrorMessage());
                stringBuilder.append(Constants.NEWLINE);
                stringBuilder.append(javacErrorDetail.getJspExtract());
                continue;
            }
            objectArray = new Object[]{javacErrorDetail.getJavaLineNumber(), javacErrorDetail.getJavaFileName()};
            stringBuilder.append(Constants.NEWLINE);
            stringBuilder.append(Constants.NEWLINE);
            stringBuilder.append(Localizer.getMessage("jsp.error.java.line.number", objectArray));
            stringBuilder.append(Constants.NEWLINE);
            stringBuilder.append(javacErrorDetail.getErrorMessage());
        }
        stringBuilder.append(Constants.NEWLINE);
        stringBuilder.append(Constants.NEWLINE);
        stringBuilder.append("Stacktrace:");
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile") + ": " + stringBuilder);
    }

    @Override
    public void javacError(String string, Exception exception) throws JasperException {
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), exception);
    }
}

