/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.monitor.ApplicationMonitorViewProvider;
import org.graalvm.visualvm.application.views.monitor.ApplicationSnapshotMonitorViewProvider;
import org.graalvm.visualvm.application.views.overview.ApplicationOverviewViewProvider;
import org.graalvm.visualvm.application.views.overview.ApplicationSnapshotOverviewViewProvider;
import org.graalvm.visualvm.application.views.threads.ApplicationSnapshotThreadsViewProvider;
import org.graalvm.visualvm.application.views.threads.ApplicationThreadsViewProvider;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.core.ui.DataSourceViewsManager;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;

public final class ApplicationViewsSupport {
    private static ApplicationViewsSupport sharedInstance;
    private ApplicationSnapshotOverviewViewProvider applicationSnapshotOverviewView = new ApplicationSnapshotOverviewViewProvider();
    private ApplicationOverviewViewProvider overviewPluggableView = new ApplicationOverviewViewProvider();
    private ApplicationSnapshotMonitorViewProvider applicationSnapshotMonitorView = new ApplicationSnapshotMonitorViewProvider();
    private ApplicationMonitorViewProvider monitorPluggableView = new ApplicationMonitorViewProvider();
    private ApplicationSnapshotThreadsViewProvider applicationSnapshotThreadsView = new ApplicationSnapshotThreadsViewProvider();
    private ApplicationThreadsViewProvider threadsPluggableView = new ApplicationThreadsViewProvider();

    public static synchronized ApplicationViewsSupport sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ApplicationViewsSupport();
        }
        return sharedInstance;
    }

    public PluggableDataSourceViewProvider<Application> getOverviewView() {
        return this.overviewPluggableView;
    }

    public PluggableDataSourceViewProvider<ApplicationSnapshot> getSnapshotOverviewView() {
        return this.applicationSnapshotOverviewView;
    }

    public PluggableDataSourceViewProvider<Application> getMonitorView() {
        return this.monitorPluggableView;
    }

    public PluggableDataSourceViewProvider<ApplicationSnapshot> getSnapshotMonitorView() {
        return this.applicationSnapshotMonitorView;
    }

    public PluggableDataSourceViewProvider<Application> getThreadsView() {
        return this.threadsPluggableView;
    }

    public PluggableDataSourceViewProvider<ApplicationSnapshot> getSnapshotThreadsView() {
        return this.applicationSnapshotThreadsView;
    }

    private ApplicationViewsSupport() {
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.overviewPluggableView, Application.class);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.applicationSnapshotOverviewView, ApplicationSnapshot.class);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.monitorPluggableView, Application.class);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.applicationSnapshotMonitorView, ApplicationSnapshot.class);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.threadsPluggableView, Application.class);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)this.applicationSnapshotThreadsView, ApplicationSnapshot.class);
    }
}

