/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class Windows8VectorCloseButton
extends VectorIcon {
    public static final Icon DEFAULT = new Windows8VectorCloseButton(false);
    public static final Icon PRESSED = new Windows8VectorCloseButton(true);
    private final boolean pressed;

    private Windows8VectorCloseButton(boolean bl) {
        super(14, 14);
        this.pressed = bl;
    }

    protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        if (this.pressed) {
            graphics2D.setColor(new Color(199, 79, 80, 255));
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.setColor(this.pressed ? Color.WHITE : new Color(86, 86, 86, 255));
        if (this.getIconWidth() == n && this.getIconHeight() == n2) {
            Windows8VectorCloseButton.setAntiAliasing((Graphics2D)graphics2D, (boolean)false);
        }
        double d2 = (this.pressed ? 1.0 : 0.8) * d;
        if (d > 1.0) {
            d2 *= 1.5;
        }
        double d3 = 3.5 * d;
        int n3 = Windows8VectorCloseButton.round((double)(3.0 * d));
        int n4 = Windows8VectorCloseButton.round((double)(4.0 * d));
        graphics2D.clip(new Rectangle2D.Double(0.0, n3, n, n2 - n3 - n4));
        graphics2D.setStroke(new BasicStroke((float)d2));
        graphics2D.draw(new Line2D.Double(d3, n3, (double)n - d3, n2 - n4));
        graphics2D.draw(new Line2D.Double((double)n - d3, n3, d3, n2 - n4));
    }
}

