/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.heapviewer.Bundle;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerComponent;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;

public final class HeapViewer {
    private final File heapDumpFile;
    private final Lookup.Provider heapDumpProject;
    private final List<HeapFragment> heapFragments;
    private JComponent component;

    public HeapViewer(File file) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread());
        this.heapDumpFile = file;
        this.heapDumpProject = null;
        this.heapFragments = HeapViewer.computeHeapFragments(this.heapDumpFile, this.heapDumpProject, HeapViewer.createHeap(this.heapDumpFile));
    }

    public File getFile() {
        return this.heapDumpFile;
    }

    public Lookup.Provider getProject() {
        return this.heapDumpProject;
    }

    public List<HeapFragment> getFragments() {
        return this.heapFragments;
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.heapFragments == null ? new NotSupportedDisplayer(Bundle.HeapViewer_HeapDumpOOME()) : (this.heapFragments.isEmpty() ? new NotSupportedDisplayer(Bundle.HeapViewer_HeapDumpEmpty()) : new HeapViewerComponent(this));
        }
        return this.component;
    }

    public void willBeRemoved() {
        if (this.component instanceof HeapViewerComponent) {
            ((HeapViewerComponent)this.component).willBeClosed();
        }
    }

    public void closed() {
        if (this.component instanceof HeapViewerComponent) {
            ((HeapViewerComponent)this.component).closed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File heapFile) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread());
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandle.createHandle((String)Bundle.HeapViewer_LoadingDumpMsg());
            pHandle.setInitialDelay(1000);
            pHandle.start(2000);
            HeapFragment.setProgress(pHandle, 0);
            Heap heap = HeapFactory.createHeap((File)heapFile);
            HeapFragment.setProgress(pHandle, 1000);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory in HeapViewer.createHeap: " + e.getMessage());
            HeapUtils.handleOOME(false, e);
            Heap heap = null;
            return heap;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    private static List<HeapFragment> computeHeapFragments(File heapDumpFile, Lookup.Provider heapDumpProject, Heap heap) throws IOException {
        if (heap == null) {
            return null;
        }
        Collection providers = Lookup.getDefault().lookupAll(HeapFragment.Provider.class);
        ArrayList<HeapFragment> fragments = new ArrayList<HeapFragment>(providers.size());
        for (HeapFragment.Provider provider : providers) {
            HeapFragment fragment = provider.getFragment(heapDumpFile, heapDumpProject, heap);
            if (fragment == null) continue;
            fragments.add(fragment);
        }
        return Collections.unmodifiableList(fragments);
    }
}

