/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="static")
public class StaticNameMapper
implements NameMapper {
    public static final String NAME = "static";
    private static final String CONFIG_PROP_NAME = "aether.syncContext.named.static.name";
    private final String name;

    @Inject
    public StaticNameMapper() {
        this(NAME);
    }

    public StaticNameMapper(String name2) {
        this.name = Objects.requireNonNull(name2);
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        return Collections.singletonList(ConfigUtils.getString(session, this.name, CONFIG_PROP_NAME));
    }
}

