// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny828.atdf, see http://packs.download.atmel.com/

// +build avr,attiny828

// Device information for the ATtiny828.
package avr

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny828"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_PCINT0       = 3  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 4  // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 5  // Pin Change Interrupt Request 2
	IRQ_PCINT3       = 6  // Pin Change Interrupt Request 3
	IRQ_WDT          = 7  // Watchdog Time-out Interrupt
	IRQ_TIMER1_CAPT  = 8  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 9  // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 10 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 11 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 12 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 13 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 14 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 15 // SPI Serial Transfer Complete
	IRQ_USART_START  = 16 // USART, Start
	IRQ_USART_RX     = 17 // USART Rx Complete
	IRQ_USART_UDRE   = 18 // USART, Data Register Empty
	IRQ_USART_TX     = 19 // USART Tx Complete
	IRQ_ADC          = 20 // ADC Conversion Complete
	IRQ_EE_READY     = 21 // EEPROM Ready
	IRQ_ANALOG_COMP  = 22 // Analog Comparator
	IRQ_TWI_SLAVE    = 23 // Two-wire Serial Interface
	IRQ_SPM_Ready    = 24 // Store Program Memory Read
	IRQ_QTRIP        = 25 // Touch Sensing
	IRQ_max          = 25 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_RESET, "__vector_RESET")
	_ = interrupt.Register(IRQ_INT0, "__vector_INT0")
	_ = interrupt.Register(IRQ_INT1, "__vector_INT1")
	_ = interrupt.Register(IRQ_PCINT0, "__vector_PCINT0")
	_ = interrupt.Register(IRQ_PCINT1, "__vector_PCINT1")
	_ = interrupt.Register(IRQ_PCINT2, "__vector_PCINT2")
	_ = interrupt.Register(IRQ_PCINT3, "__vector_PCINT3")
	_ = interrupt.Register(IRQ_WDT, "__vector_WDT")
	_ = interrupt.Register(IRQ_TIMER1_CAPT, "__vector_TIMER1_CAPT")
	_ = interrupt.Register(IRQ_TIMER1_COMPA, "__vector_TIMER1_COMPA")
	_ = interrupt.Register(IRQ_TIMER1_COMPB, "__vector_TIMER1_COMPB")
	_ = interrupt.Register(IRQ_TIMER1_OVF, "__vector_TIMER1_OVF")
	_ = interrupt.Register(IRQ_TIMER0_COMPA, "__vector_TIMER0_COMPA")
	_ = interrupt.Register(IRQ_TIMER0_COMPB, "__vector_TIMER0_COMPB")
	_ = interrupt.Register(IRQ_TIMER0_OVF, "__vector_TIMER0_OVF")
	_ = interrupt.Register(IRQ_SPI_STC, "__vector_SPI_STC")
	_ = interrupt.Register(IRQ_USART_START, "__vector_USART_START")
	_ = interrupt.Register(IRQ_USART_RX, "__vector_USART_RX")
	_ = interrupt.Register(IRQ_USART_UDRE, "__vector_USART_UDRE")
	_ = interrupt.Register(IRQ_USART_TX, "__vector_USART_TX")
	_ = interrupt.Register(IRQ_ADC, "__vector_ADC")
	_ = interrupt.Register(IRQ_EE_READY, "__vector_EE_READY")
	_ = interrupt.Register(IRQ_ANALOG_COMP, "__vector_ANALOG_COMP")
	_ = interrupt.Register(IRQ_TWI_SLAVE, "__vector_TWI_SLAVE")
	_ = interrupt.Register(IRQ_SPM_Ready, "__vector_SPM_Ready")
	_ = interrupt.Register(IRQ_QTRIP, "__vector_QTRIP")
)

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))

	// I/O Port
	PUEA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PUEB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PHDE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	PUEC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	PUED  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))

	// CPU Registers
	PRR       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	CCP       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	CLKPR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SREG      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	GPIOR2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	SMCR      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	SPMCSR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
	OSCCAL0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	OSCCAL1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x67)))
	OSCTCAL0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	OSCTCAL0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Timer/Counter Output Compare Pin
	TOCPMSA1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	TOCPMSA0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	TOCPMCOE = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))

	// Analog-to-Digital Converter
	ADMUXA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADMUXB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	DIDR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Analog Comparator
	ACSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	ACSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x73)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// EEPROM
	EEAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Two Wire Serial Interface
	TWSCRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWSCRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWSSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))
	TWSA   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSD   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWSAM  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))

	// USART
	UDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	UCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	UCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	UCSRD = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc3)))
	UBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	UBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BOOTSZ0 = 0x2  // Select boot size
	EXTENDED_BOOTSZ1 = 0x4  // Select boot size
	EXTENDED_BOOTRST = 0x1  // Boot Reset vector Enabled
	EXTENDED_BODPD0  = 0x40 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODPD1  = 0x80 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODACT0 = 0x10 // BOD mode of operation when the device is active or idle
	EXTENDED_BODACT1 = 0x20 // BOD mode of operation when the device is active or idle

	// HIGH
	HIGH_RSTDISBL  = 0x80 // Reset Disabled (Enable PC6 as i/o pin)]
	HIGH_DWEN      = 0x40 // Debug Wire enable
	HIGH_SPIEN     = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON     = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE    = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL0 = 0x1  // Brown-out Detector trigger level
	HIGH_BODLEVEL1 = 0x2  // Brown-out Detector trigger level
	HIGH_BODLEVEL2 = 0x4  // Brown-out Detector trigger level

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTB0
	LOW_SUT_CKSEL0 = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1 = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2 = 0x10 // Select Clock Source
	LOW_SUT_CKSEL3 = 0x20 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0   = 0x1  // Memory Lock
	LOCKBIT_LB1   = 0x2  // Memory Lock
	LOCKBIT_BLB00 = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01 = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB10 = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11 = 0x20 // Boot Loader Protection Mode
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL  = 0x40 // Write Collision Flag
	SPSR_SPI2X = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE = 0x80 // SPI Interrupt Enable
	SPCR_SPE  = 0x40 // SPI Enable
	SPCR_DORD = 0x20 // Data Order
	SPCR_MSTR = 0x10 // Master/Slave Select
	SPCR_CPOL = 0x8  // Clock polarity
	SPCR_CPHA = 0x4  // Clock Phase
	SPCR_SPR0 = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1 = 0x2  // SPI Clock Rate Selects
)

// Bitfields for PORT: I/O Port
const (
	// PHDE: Port High Drive Enable Register
	PHDE_PHDEC = 0x4 // Port C High Drive Enable
)

// Bitfields for CPU: CPU Registers
const (
	// PRR: Power Reduction Register
	PRR_PRTWI    = 0x80 // Power Reduction TWI
	PRR_PRTIM0   = 0x20 // Power Reduction Timer/Counter0
	PRR_PRTIM1   = 0x8  // Power Reduction Timer/Counter1
	PRR_PRSPI    = 0x4  // Power Reduction SPI
	PRR_PRUSART0 = 0x2  // Power Reduction USART 0
	PRR_PRADC    = 0x1  // Power Reduction ADC

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPS0 = 0x1 // Clock Prescaler Select Bits
	CLKPR_CLKPS1 = 0x2 // Clock Prescaler Select Bits
	CLKPR_CLKPS2 = 0x4 // Clock Prescaler Select Bits
	CLKPR_CLKPS3 = 0x8 // Clock Prescaler Select Bits

	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_IVSEL = 0x2 // Interrupt Vector Select

	// MCUSR: MCU Status Register
	MCUSR_WDRF  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF = 0x2 // External Reset Flag
	MCUSR_PORF  = 0x1 // Power-on reset flag

	// SMCR: Sleep Mode Control Register
	SMCR_SM0 = 0x2 // Sleep Mode Select Bits
	SMCR_SM1 = 0x4 // Sleep Mode Select Bits
	SMCR_SE  = 0x1 // Sleep Enable

	// SPMCSR: Store Program Memory Control and Status Register
	SPMCSR_SPMIE  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB  = 0x40 // Read-While-Write Section Busy
	SPMCSR_RSIG   = 0x20 // Read Device Signature Imprint Table
	SPMCSR_RWWSRE = 0x10 // Read-While-Write section read enable
	SPMCSR_RWFLB  = 0x8  // Read/Write Fuse and Lock Bits
	SPMCSR_PGWRT  = 0x4  // Page Write
	SPMCSR_PGERS  = 0x2  // Page Erase
	SPMCSR_SPMEN  = 0x1  // Store Program Memory Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare A
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1 = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0 = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1 = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0  = 0x1 // Timer/Counter0 Overflow Flag
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_WGM10  = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11  = 0x2  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode
	TCCR1B_CS10  = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11  = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12  = 0x4  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A = 0x80
	TCCR1C_FOC1B = 0x40
)

// Bitfields for TOCPM: Timer/Counter Output Compare Pin
const (
	// TOCPMSA1: Timer Output Compare Pin Mux Selection 1
	TOCPMSA1_TOCC7S0 = 0x40 // Timer Output Compare Channel 7 Selection Bits
	TOCPMSA1_TOCC7S1 = 0x80 // Timer Output Compare Channel 7 Selection Bits
	TOCPMSA1_TOCC6S0 = 0x10 // Timer Output Compare Channel 6 Selection Bits
	TOCPMSA1_TOCC6S1 = 0x20 // Timer Output Compare Channel 6 Selection Bits
	TOCPMSA1_TOCC5S0 = 0x4  // Timer Output Compare Channel 5 Selection Bits
	TOCPMSA1_TOCC5S1 = 0x8  // Timer Output Compare Channel 5 Selection Bits
	TOCPMSA1_TOCC4S0 = 0x1  // Timer Output Compare Channel 4 Selection Bits
	TOCPMSA1_TOCC4S1 = 0x2  // Timer Output Compare Channel 4 Selection Bits

	// TOCPMSA0: Timer Output Compare Pin Mux Selection 0
	TOCPMSA0_TOCC3S0 = 0x40 // Timer Output Compare Channel 3 Selection Bits
	TOCPMSA0_TOCC3S1 = 0x80 // Timer Output Compare Channel 3 Selection Bits
	TOCPMSA0_TOCC2S0 = 0x10 // Timer Output Compare Channel 2 Selection Bits
	TOCPMSA0_TOCC2S1 = 0x20 // Timer Output Compare Channel 2 Selection Bits
	TOCPMSA0_TOCC1S0 = 0x4  // Timer Output Compare Channel 1 Selection Bits
	TOCPMSA0_TOCC1S1 = 0x8  // Timer Output Compare Channel 1 Selection Bits
	TOCPMSA0_TOCC0S0 = 0x1  // Timer Output Compare Channel 0 Selection Bits
	TOCPMSA0_TOCC0S1 = 0x2  // Timer Output Compare Channel 0 Selection Bits

	// TOCPMCOE: Timer Output Compare Pin Mux Channel Output Enable
	TOCPMCOE_TOCC7OE = 0x80 // Timer Output Compare Channel 7 Output Enable
	TOCPMCOE_TOCC6OE = 0x40 // Timer Output Compare Channel 6 Output Enable
	TOCPMCOE_TOCC5OE = 0x20 // Timer Output Compare Channel 5 Output Enable
	TOCPMCOE_TOCC4OE = 0x10 // Timer Output Compare Channel 4 Output Enable
	TOCPMCOE_TOCC3OE = 0x8  // Timer Output Compare Channel 3 Output Enable
	TOCPMCOE_TOCC2OE = 0x4  // Timer Output Compare Channel 2 Output Enable
	TOCPMCOE_TOCC1OE = 0x2  // Timer Output Compare Channel 1 Output Enable
	TOCPMCOE_TOCC0OE = 0x1  // Timer Output Compare Channel 0 Output Enable
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUXA: The ADC multiplexer Selection Register A
	ADMUXA_MUX0 = 0x1  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX1 = 0x2  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX2 = 0x4  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX3 = 0x8  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX4 = 0x10 // Analog Channel Selection Bits 4:0

	// ADMUXB: The ADC multiplexer Selection Register B
	ADMUXB_REFS = 0x20 // Reference Selection Bit
	ADMUXB_MUX5 = 0x1  // Analog Channel Selection Bit 5

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN  = 0x80 // ADC Enable
	ADCSRA_ADSC  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0 = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1 = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2 = 0x4  // ADC Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADLAR = 0x8
	ADCSRB_ADTS0 = 0x1 // ADC Auto Trigger Sources
	ADCSRB_ADTS1 = 0x2 // ADC Auto Trigger Sources
	ADCSRB_ADTS2 = 0x4 // ADC Auto Trigger Sources

	// DIDR3: Digital Input Disable Register 2
	DIDR3_ADC27D = 0x8 // ADC27 Digital input Disable
	DIDR3_ADC26D = 0x4 // ADC26 Digital input Disable
	DIDR3_ADC25D = 0x2 // ADC25 Digital input Disable
	DIDR3_ADC24D = 0x1 // ADC24 Digital input Disable

	// DIDR2: Digital Input Disable Register 2
	DIDR2_ADC23D = 0x80 // ADC23 Digital input Disable
	DIDR2_ADC22D = 0x40 // ADC22 Digital input Disable
	DIDR2_ADC21D = 0x20 // ADC21 Digital input Disable
	DIDR2_ADC20D = 0x10 // ADC20 Digital input Disable
	DIDR2_ADC19D = 0x8  // ADC19 Digital input Disable
	DIDR2_ADC18D = 0x4  // ADC18 Digital input Disable
	DIDR2_ADC17D = 0x2  // ADC17 Digital input Disable
	DIDR2_ADC16D = 0x1  // ADC16 Digital input Disable

	// DIDR1: Digital Input Disable Register 1
	DIDR1_ADC15D = 0x80 // ADC15 Digital input Disable
	DIDR1_ADC14D = 0x40 // ADC14 Digital input Disable
	DIDR1_ADC13D = 0x20 // ADC13 Digital input Disable
	DIDR1_ADC12D = 0x10 // ADC12 Digital input Disable
	DIDR1_ADC11D = 0x8  // ADC11 Digital input Disable
	DIDR1_ADC10D = 0x4  // ADC10 Digital input Disable
	DIDR1_ADC9D  = 0x2  // ADC9 Digital input Disable
	DIDR1_ADC8D  = 0x1  // ADC8 Digital input Disable

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D = 0x1  // ADC0 Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSRB: Analog Comparator Control And Status Register B
	ACSRB_HSEL    = 0x80 // Hysteresis Select
	ACSRB_HLEV    = 0x40 // Hysteresis Level
	ACSRB_ACNMUX0 = 0x4  // Analog Comparator Negative Input Multiplexer
	ACSRB_ACNMUX1 = 0x8  // Analog Comparator Negative Input Multiplexer
	ACSRB_ACPMUX0 = 0x1  // Analog Comparator Positive Input Multiplexer Bits 1:0
	ACSRB_ACPMUX1 = 0x2  // Analog Comparator Positive Input Multiplexer Bits 1:0

	// ACSRA: Analog Comparator Control And Status Register A
	ACSRA_ACD     = 0x80 // Analog Comparator Disable
	ACSRA_ACPMUX2 = 0x40 // Analog Comparator Positive Input Multiplexer Bit 2
	ACSRA_ACO     = 0x20 // Analog Compare Output
	ACSRA_ACI     = 0x10 // Analog Comparator Interrupt Flag
	ACSRA_ACIE    = 0x8  // Analog Comparator Interrupt Enable
	ACSRA_ACIC    = 0x4  // Analog Comparator Input Capture Enable
	ACSRA_ACIS0   = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSRA_ACIS1   = 0x2  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC10 = 0x4 // External Interrupt Sense Control 1 Bits
	EICRA_ISC11 = 0x8 // External Interrupt Sense Control 1 Bits
	EICRA_ISC00 = 0x1 // External Interrupt Sense Control 0 Bits
	EICRA_ISC01 = 0x2 // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0 = 0x1 // External Interrupt Request Enables
	EIMSK_INT1 = 0x2 // External Interrupt Request Enables

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0 = 0x1 // External Interrupt Flags
	EIFR_INTF1 = 0x2 // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0 = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1 = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2 = 0x4 // Pin Change Interrupt Enables
	PCICR_PCIE3 = 0x8 // Pin Change Interrupt Enables

	// PCMSK3: Pin Change Mask Register 3
	PCMSK3_PCINT0 = 0x1 // Pin Change Enable Masks
	PCMSK3_PCINT1 = 0x2 // Pin Change Enable Masks
	PCMSK3_PCINT2 = 0x4 // Pin Change Enable Masks
	PCMSK3_PCINT3 = 0x8 // Pin Change Enable Masks

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK2_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK2_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0 = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1 = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2 = 0x4 // Pin Change Interrupt Flags
	PCIFR_PCIF3 = 0x8 // Pin Change Interrupt Flags
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control and Status Register
	WDTCSR_WDIF = 0x80 // Watchdog Timer Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timer Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDE  = 0x8  // Watch Dog Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0 = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1 = 0x20 // EEPROM Programming Mode Bits
	EECR_EERIE = 0x8  // EEProm Ready Interrupt Enable
	EECR_EEMPE = 0x4  // EEPROM Master Write Enable
	EECR_EEPE  = 0x2  // EEPROM Write Enable
	EECR_EERE  = 0x1  // EEPROM Read Enable
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWSCRA: TWI Slave Control Register A
	TWSCRA_TWSHE  = 0x80 // TWI SDA Hold Time Enable
	TWSCRA_TWDIE  = 0x20 // TWI Data Interrupt Enable
	TWSCRA_TWASIE = 0x10 // TWI Address/Stop Interrupt Enable
	TWSCRA_TWEN   = 0x8  // Two-Wire Interface Enable
	TWSCRA_TWSIE  = 0x4  // TWI Stop Interrupt Enable
	TWSCRA_TWPME  = 0x2  // TWI Promiscuous Mode Enable
	TWSCRA_TWSME  = 0x1  // TWI Smart Mode Enable

	// TWSCRB: TWI Slave Control Register B
	TWSCRB_TWHNM  = 0x8 // TWI High Noise Mode
	TWSCRB_TWAA   = 0x4 // TWI Acknowledge Action
	TWSCRB_TWCMD0 = 0x1
	TWSCRB_TWCMD1 = 0x2

	// TWSSRA: TWI Slave Status Register A
	TWSSRA_TWDIF  = 0x80 // TWI Data Interrupt Flag.
	TWSSRA_TWASIF = 0x40 // TWI Address/Stop Interrupt Flag
	TWSSRA_TWCH   = 0x20 // TWI Clock Hold
	TWSSRA_TWRA   = 0x10 // TWI Receive Acknowledge
	TWSSRA_TWC    = 0x8  // TWI Collision
	TWSSRA_TWBE   = 0x4  // TWI Bus Error
	TWSSRA_TWDIR  = 0x2  // TWI Read/Write Direction
	TWSSRA_TWAS   = 0x1  // TWI Address or Stop

	// TWSD: TWI Slave Data Register
	TWSD_TWSD0 = 0x1  // TWI slave data bit
	TWSD_TWSD1 = 0x2  // TWI slave data bit
	TWSD_TWSD2 = 0x4  // TWI slave data bit
	TWSD_TWSD3 = 0x8  // TWI slave data bit
	TWSD_TWSD4 = 0x10 // TWI slave data bit
	TWSD_TWSD5 = 0x20 // TWI slave data bit
	TWSD_TWSD6 = 0x40 // TWI slave data bit
	TWSD_TWSD7 = 0x80 // TWI slave data bit

	// TWSAM: TWI Slave Address Mask Register
	TWSAM_TWSAM0 = 0x2  // TWI Address Mask Bits
	TWSAM_TWSAM1 = 0x4  // TWI Address Mask Bits
	TWSAM_TWSAM2 = 0x8  // TWI Address Mask Bits
	TWSAM_TWSAM3 = 0x10 // TWI Address Mask Bits
	TWSAM_TWSAM4 = 0x20 // TWI Address Mask Bits
	TWSAM_TWSAM5 = 0x40 // TWI Address Mask Bits
	TWSAM_TWSAM6 = 0x80 // TWI Address Mask Bits
	TWSAM_TWAE   = 0x1  // TWI Address Enable
)

// Bitfields for USART: USART
const (
	// UCSRA: USART Control and Status Register A
	UCSRA_RXC  = 0x80 // USART Receive Complete
	UCSRA_TXC  = 0x40 // USART Transmitt Complete
	UCSRA_UDRE = 0x20 // USART Data Register Empty
	UCSRA_FE   = 0x10 // Framing Error
	UCSRA_DOR  = 0x8  // Data overRun
	UCSRA_UPE  = 0x4  // Parity Error
	UCSRA_U2X  = 0x2  // Double the USART transmission speed
	UCSRA_MPCM = 0x1  // Multi-processor Communication Mode

	// UCSRB: USART Control and Status Register B
	UCSRB_RXCIE = 0x80 // RX Complete Interrupt Enable
	UCSRB_TXCIE = 0x40 // TX Complete Interrupt Enable
	UCSRB_UDRIE = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_RXEN  = 0x10 // Receiver Enable
	UCSRB_TXEN  = 0x8  // Transmitter Enable
	UCSRB_UCSZ2 = 0x4  // Character Size
	UCSRB_RXB8  = 0x2  // Receive Data Bit 8
	UCSRB_TXB8  = 0x1  // Transmit Data Bit 8

	// UCSRC: USART Control and Status Register C
	UCSRC_UMSEL0 = 0x40 // USART Mode Select
	UCSRC_UMSEL1 = 0x80 // USART Mode Select
	UCSRC_UPM0   = 0x10 // Parity Mode Bits
	UCSRC_UPM1   = 0x20 // Parity Mode Bits
	UCSRC_USBS   = 0x8  // Stop Bit Select
	UCSRC_UCSZ0  = 0x2  // Character Size
	UCSRC_UCSZ1  = 0x4  // Character Size
	UCSRC_UCPOL  = 0x1  // Clock Polarity

	// UCSRD: USART Control and Status Register D
	UCSRD_RXSIE = 0x80 // USART RX Start Interrupt Enable
	UCSRD_RXS   = 0x40 // USART RX Start Flag
	UCSRD_SFDE  = 0x20 // USART RX Start Frame Detection Enable
)
