/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747StringTokenizer;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class CSVLogConvert
extends GPSLogConvertInterface {
    private static final String[] MONTHS_AS_TEXT = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private GPSRecord logFormatRecord;
    private GPSRecord activeFileFieldsRecord;
    private boolean passToFindFieldsActivatedInLog = false;
    private int error;

    @Override
    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        object = (WindowedFile)object;
        GPSRecord.getLogFormatRecord(0);
        boolean bl = true;
        int[] nArray = new int[30];
        try {
            int n;
            nArray[0] = -1;
            int n2 = 0;
            this.logFormatRecord = GPSRecord.getLogFormatRecord(0);
            int n3 = 0;
            try {
                n = ((WindowedFile)object).getSize();
            }
            catch (Exception exception) {
                Generic.debug("getSize", exception);
                n = 0;
            }
            while (!this.stop && n3 < n) {
                boolean bl2;
                byte[] byArray;
                int n4 = 2048;
                if (n3 + 2048 > n) {
                    n4 = n - n3;
                }
                int n5 = 0;
                try {
                    byArray = ((WindowedFile)object).fillBuffer(n3);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = ((WindowedFile)object).getPath() + "|" + ((WindowedFile)object).getLastError();
                    return -3;
                }
                n3 += n4;
                do {
                    int n6;
                    for (n6 = n5; n6 < n4 && byArray[n6] != 10 && byArray[n6] != 13; ++n6) {
                    }
                    bl2 = n6 < n4;
                    if (!bl2) continue;
                    StringBuffer stringBuffer = new StringBuffer(n6 - n5 + 1);
                    for (int i = n5; i < n6; ++i) {
                        stringBuffer.append((char)byArray[i]);
                    }
                    Object object2 = JavaLibBridge.getStringTokenizerInstance(stringBuffer.toString(), ',');
                    for (n5 = n6; n5 < n4 && (byArray[n5] == 10 || byArray[n5] == 13); ++n5) {
                    }
                    if (stringBuffer.length() == 0) continue;
                    if (bl) {
                        bl = false;
                        int n7 = 0;
                        this.activeFileFieldsRecord = GPSRecord.getLogFormatRecord(0);
                        for (int i = 0; object2.hasMoreTokens() && i < 30; ++i) {
                            String string = object2.nextToken();
                            if (string.equals("INDEX")) {
                                nArray[i] = -4;
                            } else if (string.equals("RCR") || string.equals("TAG")) {
                                nArray[i] = 17;
                                n7 |= 0x20000;
                            } else if (string.equals("TIME")) {
                                nArray[i] = -2;
                                n7 |= 1;
                            } else if (string.equals("DATE")) {
                                nArray[i] = -3;
                                n7 |= 1;
                            } else if (string.equals("FIX MODE")) {
                                nArray[i] = -13;
                                n7 |= 2;
                            } else if (string.equals("VALID")) {
                                nArray[i] = 1;
                                n7 |= 2;
                            } else if (string.equals("LATITUDE")) {
                                nArray[i] = 2;
                                n7 |= 4;
                            } else if (string.equals("N/S")) {
                                nArray[i] = -6;
                            } else if (string.equals("LONGITUDE")) {
                                nArray[i] = 3;
                                n7 |= 8;
                            } else if (string.equals("E/W")) {
                                nArray[i] = -5;
                            } else if (string.startsWith("HEIGHT(ft)")) {
                                nArray[i] = 104;
                                n7 |= 0x10;
                            } else if (string.startsWith("HEIGHT")) {
                                nArray[i] = 4;
                                n7 |= 0x10;
                            } else if (string.startsWith("SPEED(mph)")) {
                                nArray[i] = 105;
                                n7 |= 0x20;
                            } else if (string.startsWith("SPEED")) {
                                nArray[i] = 5;
                                n7 |= 0x20;
                            } else if (string.equals("HEADING")) {
                                nArray[i] = 6;
                                n7 |= 0x40;
                            } else if (string.equals("DSTA")) {
                                nArray[i] = 7;
                                n7 |= 0x80;
                            } else if (string.equals("DAGE")) {
                                nArray[i] = 8;
                                n7 |= 0x100;
                            } else if (string.equals("PDOP")) {
                                nArray[i] = 9;
                                n7 |= 0x200;
                            } else if (string.equals("HDOP")) {
                                nArray[i] = 10;
                                n7 |= 0x400;
                            } else if (string.equals("VDOP")) {
                                nArray[i] = 11;
                                n7 |= 0x800;
                            } else if (string.equals("NSAT (USED/VIEW)")) {
                                nArray[i] = 12;
                                n7 |= 0x1000;
                            } else if (string.startsWith("DISTANCE(ft)")) {
                                nArray[i] = 119;
                                n7 |= 0x80000;
                            } else if (string.startsWith("DISTANCE")) {
                                nArray[i] = 19;
                                n7 |= 0x80000;
                            } else if (string.startsWith("SAT INFO (SID")) {
                                nArray[i] = 13;
                                n7 |= 0x2000;
                                if (string.indexOf("-ELE", 12) != -1) {
                                    n7 |= 0x4000;
                                }
                                if (string.indexOf("-AZI", 12) != -1) {
                                    n7 |= 0x8000;
                                }
                                if (string.indexOf("-SNR", 12) != -1) {
                                    n7 |= 0x10000;
                                }
                            } else if (string.equals("LATITUDE N/S")) {
                                nArray[i] = -10;
                                n7 |= 4;
                            } else if (string.equals("LONGITUDE E/W")) {
                                nArray[i] = -11;
                                n7 |= 8;
                            } else if (string.startsWith("LOGTIME")) {
                                nArray[i] = -9;
                                this.activeFileFieldsRecord.logPeriod = 1;
                            } else if (string.startsWith("LOGDIST")) {
                                nArray[i] = -8;
                                this.activeFileFieldsRecord.logDistance = 1;
                            } else if (string.startsWith("LOGSPD")) {
                                nArray[i] = -7;
                                this.activeFileFieldsRecord.logSpeed = 1;
                            } else if (string.equals("VOX")) {
                                nArray[i] = -12;
                                this.activeFileFieldsRecord.voxStr = "";
                            } else {
                                nArray[i] = -100;
                            }
                            nArray[i + 1] = -1;
                        }
                        this.activeFileFieldsRecord.cloneActiveFields(GPSRecord.getLogFormatRecord(n7));
                        if (!this.passToFindFieldsActivatedInLog) continue;
                        return 0;
                    }
                    GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
                    GPSRecord.getLogFormatRecord(0).recCount = ++n2;
                    for (int i = 0; object2.hasMoreTokens() && i < 30 && nArray[i] != -1; ++i) {
                        String string = object2.nextToken().trim();
                        if (string.length() == 0) continue;
                        int n8 = nArray[i];
                        n2 = this.readField(n8, string, gPSRecord, n2);
                    }
                    GPSRecord gPSRecord2 = gPSRecord;
                    object2 = gPSFileConverterInterface;
                    CSVLogConvert cSVLogConvert = this;
                    if (!gPSRecord2.equalsFormat(cSVLogConvert.logFormatRecord)) {
                        cSVLogConvert.logFormatRecord = gPSRecord2.cloneRecord();
                        cSVLogConvert.activeFileFieldsRecord.cloneActiveFields(cSVLogConvert.logFormatRecord);
                        if (!cSVLogConvert.passToFindFieldsActivatedInLog) {
                            object2.writeLogFmtHeader(cSVLogConvert.logFormatRecord);
                        }
                    }
                    CommonIn.adjustHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                    if (gPSRecord.rcr == 0) {
                        gPSRecord.rcr = 1;
                    }
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    GPSRecord.getLogFormatRecord(0);
                } while (bl2);
                if (n5 != 0) {
                    n3 -= n4 - n5;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Generic.debug("parseFile", exception);
        }
        return 0;
    }

    private final int readField(int n, String string, GPSRecord gPSRecord, int n2) {
        try {
            switch (n) {
                case -9: {
                    gPSRecord.logPeriod = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -8: {
                    gPSRecord.logDistance = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -7: {
                    gPSRecord.logSpeed = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -6: {
                    if (string.equals("N")) {
                        gPSRecord.latitude = Math.abs(gPSRecord.latitude);
                        break;
                    }
                    if (string.equals("S")) {
                        gPSRecord.latitude = -Math.abs(gPSRecord.latitude);
                    }
                    break;
                }
                case -5: {
                    if (string.equals("E")) {
                        gPSRecord.longitude = Math.abs(gPSRecord.longitude);
                        break;
                    }
                    if (string.equals("W")) {
                        gPSRecord.longitude = -Math.abs(gPSRecord.longitude);
                    }
                    break;
                }
                case -4: {
                    n2 = gPSRecord.recCount = JavaLibBridge.toInt(string);
                    break;
                }
                case -3: {
                    if (string.length() == 10) {
                        n = string.indexOf(47) == 4 ? 1 : 2;
                        int n3 = JavaLibBridge.getDateInstance(string, (byte)n).dateToUTCepoch1970();
                        gPSRecord.utc += n3;
                        break;
                    }
                    if (string.length() == 9) {
                        if (string.charAt(2) == '-' && string.charAt(6) == '-') {
                            int n4;
                            n = JavaLibBridge.toInt(string.substring(0, 2));
                            int n5 = JavaLibBridge.toInt(string.substring(7, 9)) + 2000;
                            String string2 = string.substring(3, 6);
                            if (string2.equals(MONTHS_AS_TEXT[0])) {
                                n4 = 0;
                            } else {
                                for (n4 = 0; n4 < 12 && !string2.equals(string2); ++n4) {
                                }
                            }
                            if (n4 < 12) {
                                gPSRecord.utc += JavaLibBridge.getDateInstance(n, n4 + 1, n5).dateToUTCepoch1970();
                            }
                        }
                    } else if (string.length() == 6) {
                        int n6 = JavaLibBridge.toInt(string.substring(0, 2)) + 2000;
                        int n7 = JavaLibBridge.toInt(string.substring(2, 4));
                        n = JavaLibBridge.toInt(string.substring(4, 6));
                        gPSRecord.utc += JavaLibBridge.getDateInstance(n, n7, n6).dateToUTCepoch1970();
                    }
                    break;
                }
                case -2: {
                    BT747StringTokenizer bT747StringTokenizer;
                    if (string.length() == 6) {
                        int n8 = JavaLibBridge.toInt(string.substring(0, 2));
                        int n9 = JavaLibBridge.toInt(string.substring(2, 4));
                        n = JavaLibBridge.toInt(string.substring(4, 6));
                        gPSRecord.utc += n + n9 * 60 + n8 * 3600;
                        break;
                    }
                    n = string.indexOf(46);
                    if (n != -1) {
                        gPSRecord.milisecond = JavaLibBridge.toInt(string.substring(n + 1));
                        string = string.substring(0, n);
                    }
                    if ((bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ':')).countTokens() == 3) {
                        gPSRecord.utc += JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) * 3600 + JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) * 60 + JavaLibBridge.toInt(bT747StringTokenizer.nextToken());
                    }
                    break;
                }
                case 1: {
                    if (string.equals("No fix")) {
                        gPSRecord.valid = 1;
                        break;
                    }
                    if (string.equals("SPS")) {
                        gPSRecord.valid = 2;
                        break;
                    }
                    if (string.equals("DGPS")) {
                        gPSRecord.valid = 4;
                        break;
                    }
                    if (string.equals("PPS")) {
                        gPSRecord.valid = 8;
                        break;
                    }
                    if (string.equals("RTK")) {
                        gPSRecord.valid = 16;
                        break;
                    }
                    if (string.equals("FRTK")) {
                        gPSRecord.valid = 32;
                        break;
                    }
                    if (string.equals("Estimated mode")) {
                        gPSRecord.valid = 64;
                        break;
                    }
                    if (string.equals("Manual input mode")) {
                        gPSRecord.valid = 128;
                        break;
                    }
                    if (string.equals("Simulator mode")) {
                        gPSRecord.valid = 256;
                    }
                    break;
                }
                case -10: {
                    String string3 = string.substring(0, string.length() - 1);
                    char c = string.charAt(string3.length());
                    gPSRecord.latitude = JavaLibBridge.toDouble(string3);
                    if (c == 'N' && gPSRecord.latitude < 0.0 || c == 'S' && gPSRecord.latitude > 0.0) {
                        gPSRecord.latitude = -gPSRecord.latitude;
                    }
                    break;
                }
                case -11: {
                    String string4 = string.substring(0, string.length() - 1);
                    char c = string.charAt(string4.length());
                    gPSRecord.longitude = JavaLibBridge.toDouble(string4);
                    if (c == 'E' && gPSRecord.longitude < 0.0 || c == 'W' && gPSRecord.longitude > 0.0) {
                        gPSRecord.longitude = -gPSRecord.longitude;
                    }
                    break;
                }
                case 2: {
                    gPSRecord.latitude = JavaLibBridge.toDouble(string);
                    break;
                }
                case 3: {
                    gPSRecord.longitude = JavaLibBridge.toDouble(string);
                    break;
                }
                case 4: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.height = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken());
                    break;
                }
                case 104: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.height = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken()) / 3.28084f;
                    break;
                }
                case 5: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.speed = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken());
                    break;
                }
                case 105: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.speed = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken()) / 0.6213712f;
                    break;
                }
                case 6: {
                    gPSRecord.heading = JavaLibBridge.toFloat(string);
                    break;
                }
                case 7: {
                    gPSRecord.dsta = JavaLibBridge.toInt(string);
                    break;
                }
                case 8: {
                    gPSRecord.dage = JavaLibBridge.toInt(string);
                    break;
                }
                case 9: {
                    gPSRecord.pdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 10: {
                    gPSRecord.hdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 11: {
                    gPSRecord.vdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 12: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, '(');
                    if (bT747StringTokenizer.countTokens() >= 2) {
                        gPSRecord.nsat = JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) << 8;
                        String string5 = bT747StringTokenizer.nextToken();
                        string5 = string5.substring(0, string5.indexOf(41));
                        gPSRecord.nsat += JavaLibBridge.toInt(string5);
                    }
                    break;
                }
                case -13: {
                    break;
                }
                case 32: {
                    break;
                }
                case 13: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ';');
                    int n10 = bT747StringTokenizer.countTokens();
                    gPSRecord.sid = new int[n10];
                    gPSRecord.sidinuse = new boolean[n10];
                    gPSRecord.ele = new int[n10];
                    gPSRecord.azi = new int[n10];
                    gPSRecord.snr = new int[n10];
                    for (int i = 0; i < n10; ++i) {
                        Object object = bT747StringTokenizer.nextToken();
                        if (((String)object).length() == 0) continue;
                        gPSRecord.sidinuse[i] = ((String)object).charAt(0) == '#';
                        if ((object = JavaLibBridge.getStringTokenizerInstance(((String)object).substring(gPSRecord.sidinuse[i] ? 1 : 0), '-')).hasMoreTokens()) {
                            gPSRecord.sid[i] = JavaLibBridge.toInt(object.nextToken());
                        }
                        if (this.activeFileFieldsRecord.hasEle() && object.hasMoreTokens()) {
                            gPSRecord.ele[i] = JavaLibBridge.toInt(object.nextToken());
                        }
                        if (this.activeFileFieldsRecord.hasAzi() && object.hasMoreTokens()) {
                            gPSRecord.azi[i] = JavaLibBridge.toInt(object.nextToken());
                        }
                        if (!this.activeFileFieldsRecord.hasSnr() || !object.hasMoreTokens()) continue;
                        gPSRecord.snr[i] = JavaLibBridge.toInt(object.nextToken());
                    }
                    break;
                }
                case -12: {
                    if (string.length() != 0) {
                        gPSRecord.voxStr = string;
                    }
                    break;
                }
                case 17: {
                    gPSRecord.rcr = 0;
                    if (string.charAt(0) != 'X') {
                        if (string.indexOf(66, 0) != -1) {
                            gPSRecord.rcr |= 8;
                        }
                        if (string.indexOf(84, 0) != -1) {
                            gPSRecord.rcr |= 1;
                        }
                        if (string.indexOf(83, 0) != -1) {
                            gPSRecord.rcr |= 2;
                        }
                        if (string.indexOf(68, 0) != -1) {
                            gPSRecord.rcr |= 4;
                        }
                        if (string.indexOf(86, 0) != -1) {
                            gPSRecord.rcr = 768;
                        }
                        if (string.indexOf(67, 0) != -1) {
                            gPSRecord.rcr = 1280;
                        }
                    } else if (string.length() == 5) {
                        gPSRecord.rcr = Conv.hex2Int(string.substring(1));
                    }
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.distance = JavaLibBridge.toDouble(bT747StringTokenizer.nextToken());
                    break;
                }
                case 119: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.distance = JavaLibBridge.toDouble(bT747StringTokenizer.nextToken()) / 3.28083989501312;
                }
            }
        }
        catch (Exception exception) {
            Generic.debug("Problem reading record " + gPSRecord.recCount + " field \"" + string + "\"");
        }
        return n2;
    }

    @Override
    protected final Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(2048);
                this.errorInfo = bT747Path + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    @Override
    protected final void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    @Override
    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    this.error = this.parseFile(object, gPSFileConverterInterface);
                    gPSFileConverterInterface.setActiveFileFields(this.activeFileFieldsRecord);
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("toGPSFile", exception);
        }
        return this.error;
    }

    @Override
    public final int getType() {
        return 1;
    }
}

