/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    protected long edgeCount() {
        long degreeSum = 0L;
        for (Object node2 : this.nodes()) {
            degreeSum += (long)this.degree(node2);
        }
        Preconditions.checkState((degreeSum & 1L) == 0L);
        return degreeSum >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractBaseGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractBaseGraph.this.edgeCount());
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(@NullableDecl Object obj) {
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                return AbstractBaseGraph.this.isDirected() == endpointPair.isOrdered() && AbstractBaseGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractBaseGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N node2) {
        Preconditions.checkNotNull(node2);
        Preconditions.checkArgument(this.nodes().contains(node2), "Node %s is not an element of this graph.", node2);
        return IncidentEdgeSet.of(this, node2);
    }

    @Override
    public int degree(N node2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors(node2).size(), this.successors(node2).size());
        }
        Set<N> neighbors = this.adjacentNodes(node2);
        int selfLoopCount = this.allowsSelfLoops() && neighbors.contains(node2) ? 1 : 0;
        return IntMath.saturatedAdd(neighbors.size(), selfLoopCount);
    }

    @Override
    public int inDegree(N node2) {
        return this.isDirected() ? this.predecessors(node2).size() : this.degree(node2);
    }

    @Override
    public int outDegree(N node2) {
        return this.isDirected() ? this.successors(node2).size() : this.degree(node2);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        Preconditions.checkNotNull(nodeU);
        Preconditions.checkNotNull(nodeV);
        return this.nodes().contains(nodeU) && this.successors(nodeU).contains(nodeV);
    }

    private static abstract class IncidentEdgeSet<N>
    extends AbstractSet<EndpointPair<N>> {
        protected final N node;
        protected final BaseGraph<N> graph;

        public static <N> IncidentEdgeSet<N> of(BaseGraph<N> graph, N node2) {
            return graph.isDirected() ? new Directed(graph, node2) : new Undirected(graph, node2);
        }

        private IncidentEdgeSet(BaseGraph<N> graph, N node2) {
            this.graph = graph;
            this.node = node2;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        private static final class Undirected<N>
        extends IncidentEdgeSet<N> {
            private Undirected(BaseGraph<N> graph, N node2) {
                super(graph, node2);
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N adjacentNode) {
                        return EndpointPair.unordered(Undirected.this.node, adjacentNode);
                    }
                }));
            }

            @Override
            public int size() {
                return this.graph.adjacentNodes(this.node).size();
            }

            @Override
            public boolean contains(@NullableDecl Object obj) {
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                if (endpointPair.isOrdered()) {
                    return false;
                }
                Set<Object> adjacent = this.graph.adjacentNodes(this.node);
                Object nodeU = endpointPair.nodeU();
                Object nodeV = endpointPair.nodeV();
                return this.node.equals(nodeV) && adjacent.contains(nodeU) || this.node.equals(nodeU) && adjacent.contains(nodeV);
            }
        }

        private static final class Directed<N>
        extends IncidentEdgeSet<N> {
            private Directed(BaseGraph<N> graph, N node2) {
                super(graph, node2);
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(Iterators.transform(this.graph.predecessors(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N predecessor) {
                        return EndpointPair.ordered(predecessor, Directed.this.node);
                    }
                }), Iterators.transform(Sets.difference(this.graph.successors(this.node), ImmutableSet.of(this.node)).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N successor) {
                        return EndpointPair.ordered(Directed.this.node, successor);
                    }
                })));
            }

            @Override
            public int size() {
                return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - (this.graph.successors(this.node).contains(this.node) ? 1 : 0);
            }

            @Override
            public boolean contains(@NullableDecl Object obj) {
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                if (!endpointPair.isOrdered()) {
                    return false;
                }
                Object source2 = endpointPair.source();
                Object target = endpointPair.target();
                return this.node.equals(source2) && this.graph.successors(this.node).contains(target) || this.node.equals(target) && this.graph.predecessors(this.node).contains(source2);
            }
        }
    }
}

