/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import tim.prune.function.deletebydate.DateInfo;

public class DateInfoList {
    private List<DateInfo> _infoList = new ArrayList<DateInfo>();
    private DateInfo _previousInfo = null;
    private boolean _hasBeenSorted = false;

    public void addPoint(Date date) {
        DateInfo dateInfo = null;
        if (this._previousInfo != null && this._previousInfo.isSameDate(date)) {
            dateInfo = this._previousInfo;
        } else {
            for (DateInfo dateInfo2 : this._infoList) {
                if (!dateInfo2.isSameDate(date)) continue;
                dateInfo = dateInfo2;
                break;
            }
            if (dateInfo == null) {
                dateInfo = new DateInfo(date);
                this._infoList.add(dateInfo);
                this._hasBeenSorted = false;
            }
            this._previousInfo = dateInfo;
        }
        dateInfo.incrementCount();
    }

    public void clearAll() {
        this._infoList.clear();
        this._previousInfo = null;
        this._hasBeenSorted = true;
    }

    public int getNumEntries() {
        return this._infoList.size();
    }

    public int getTotalNumPoints() {
        int n = 0;
        for (DateInfo dateInfo : this._infoList) {
            n += dateInfo.getPointCount();
        }
        return n;
    }

    private void sort() {
        if (!this._hasBeenSorted) {
            Collections.sort(this._infoList);
            this._hasBeenSorted = true;
        }
    }

    public DateInfo getDateInfo(int n) {
        this.sort();
        return this._infoList.get(n);
    }
}

