/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.oregon.Keyboard;
import net.sourceforge.plantuml.oregon.KeyboardList;
import net.sourceforge.plantuml.oregon.NoInputException;
import net.sourceforge.plantuml.oregon.OregonBasicGame;
import net.sourceforge.plantuml.oregon.Screen;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class PSystemOregon
extends PlainDiagram {
    private Screen screen;
    private List<String> inputs;

    @Deprecated
    public PSystemOregon(Keyboard keyboard) {
        OregonBasicGame game = new OregonBasicGame();
        try {
            game.run(keyboard);
            this.screen = game.getScreen();
        }
        catch (NoInputException e) {
            this.screen = game.getScreen();
        }
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).blackBackcolor();
    }

    public PSystemOregon() {
        this.inputs = new ArrayList<String>();
    }

    public void add(String line) {
        if (StringUtils.isNotEmpty(line)) {
            this.inputs.add(line);
        }
    }

    private Screen getScreen() {
        if (this.screen == null) {
            KeyboardList keyboard = new KeyboardList(this.inputs);
            OregonBasicGame game = new OregonBasicGame();
            try {
                game.run(keyboard);
                this.screen = game.getScreen();
            }
            catch (NoInputException e) {
                this.screen = game.getScreen();
            }
        }
        return this.screen;
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        return GraphicStrings.createGreenOnBlackMonospaced(this.getScreen().getLines());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(The Oregon Trail)");
    }
}

