/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.PLSSignature;
import net.sourceforge.plantuml.version.Version;

public class PSystemKeygen
extends PlainDiagram {
    private final String key;

    public PSystemKeygen(String key) {
        this.key = key;
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    PSystemKeygen.this.drawInternal(ug);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Key)");
    }

    private void drawInternal(UGraphic ug) throws IOException {
        LicenseInfo installed = LicenseInfo.retrieveNamedSlow();
        if (this.key.length() == 0) {
            this.drawFlash(ug, installed);
            return;
        }
        LicenseInfo info = LicenseInfo.retrieveNamed(this.key);
        if (info.isNone()) {
            this.drawFlash(ug, installed);
            return;
        }
        ArrayList<String> strings = this.header();
        strings.add("<u>Provided license information</u>:");
        License.addLicenseInfo(strings, info);
        strings.add(" ");
        strings.add("========================================================================");
        try {
            LicenseInfo.persistMe(this.key);
        }
        catch (BackingStoreException e) {
            strings.add("<i>Error: Cannot store license key.</i>");
        }
        if (installed.isNone()) {
            strings.add("No license currently installed.");
            strings.add(" ");
            strings.add("<b>Please copy license.txt to one of those files</b>:");
            for (SFile f : LicenseInfo.fileCandidates()) {
                strings.add(f.getAbsolutePath());
            }
            strings.add(" ");
        } else {
            strings.add("<u>Installed license</u>:");
            License.addLicenseInfo(strings, installed);
            strings.add(" ");
        }
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
    }

    private ArrayList<String> header() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        strings.add(" ");
        return strings;
    }

    private void drawFlash(UGraphic ug, LicenseInfo info) throws IOException {
        ArrayList<String> strings = this.header();
        strings.add("To get your <i>Professional Edition License</i>,");
        strings.add("please send this qrcode to <b>plantuml@gmail.com</b> :");
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
        ug = ug.apply(UTranslate.dy(disp.calculateDimension(ug.getStringBounder()).getHeight()));
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        BufferedImage im = utils.exportFlashcode(Version.versionString() + "\n" + SignatureUtils.toHexString(PLSSignature.signature()), Color.BLACK, Color.WHITE);
        if (im != null) {
            UImage flash = new UImage(new PixelImage(im, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(4.0);
            ug.draw(flash);
            ug = ug.apply(UTranslate.dy(flash.getHeight()));
        }
        if (!info.isNone()) {
            strings.clear();
            strings.add("<u>Installed license</u>:");
            License.addLicenseInfo(strings, info);
            strings.add(" ");
            disp = GraphicStrings.createBlackOnWhite(strings);
            disp.drawU(ug);
        }
    }
}

