/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.texplate.exceptions.InvalidKeySetException;
import org.islandoftex.texplate.model.Template;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J$\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/islandoftex/texplate/util/ValidatorUtils;", "", "()V", "validate", "", "", "template", "Lorg/islandoftex/texplate/model/Template;", "map", "validateRequirements", "", "texplate"})
public final class ValidatorUtils {
    public static final ValidatorUtils INSTANCE;

    private final boolean validateRequirements(Template template, Map<String, String> map) {
        Collection collection = template.getRequirements();
        boolean bl = false;
        boolean bl2 = false;
        return collection == null || collection.isEmpty() || template.getRequirements().containsAll((Collection)map.keySet());
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> validate(@NotNull Template template, @NotNull Map<String, String> map) throws InvalidKeySetException {
        Intrinsics.checkParameterIsNotNull(template, "template");
        Intrinsics.checkParameterIsNotNull(map, "map");
        if (!INSTANCE.validateRequirements(template, map)) {
            throw (Throwable)new InvalidKeySetException("The provided map does not contain all the keys required by the chosen template. Make sure to define such keys and try again. Check the user manual for further details.");
        }
        return map;
    }

    private ValidatorUtils() {
    }

    static {
        ValidatorUtils validatorUtils;
        INSTANCE = validatorUtils = new ValidatorUtils();
    }
}

