/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Utf8Encoder;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.FutureToSendHandler;
import org.apache.tomcat.websocket.MessagePart;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsSession;

public abstract class WsRemoteEndpointImplBase
implements RemoteEndpoint {
    protected static final StringManager sm = StringManager.getManager(WsRemoteEndpointImplBase.class);
    protected static final SendResult SENDRESULT_OK = new SendResult();
    private final Log log = LogFactory.getLog(WsRemoteEndpointImplBase.class);
    private final StateMachine stateMachine = new StateMachine();
    private final IntermediateMessageHandler intermediateMessageHandler = new IntermediateMessageHandler(this);
    private Transformation transformation = null;
    private final Semaphore messagePartInProgress = new Semaphore(1);
    private final Queue<MessagePart> messagePartQueue = new ArrayDeque<MessagePart>();
    private final Object messagePartLock = new Object();
    private volatile boolean closed = false;
    private boolean fragmented = false;
    private boolean nextFragmented = false;
    private boolean text = false;
    private boolean nextText = false;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(14);
    private final ByteBuffer outputBuffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
    private final CharsetEncoder encoder = new Utf8Encoder();
    private final ByteBuffer encoderBuffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
    private final AtomicBoolean batchingAllowed = new AtomicBoolean(false);
    private volatile long sendTimeout = -1L;
    private WsSession wsSession;
    private List<EncoderEntry> encoderEntries = new ArrayList<EncoderEntry>();

    protected void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long l) {
        this.sendTimeout = l;
    }

    public void setBatchingAllowed(boolean bl) throws IOException {
        boolean bl2 = this.batchingAllowed.getAndSet(bl);
        if (bl2 && !bl) {
            this.flushBatch();
        }
    }

    public boolean getBatchingAllowed() {
        return this.batchingAllowed.get();
    }

    public void flushBatch() throws IOException {
        this.sendMessageBlock((byte)24, null, true);
    }

    public void sendBytes(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        this.stateMachine.binaryStart();
        this.sendMessageBlock((byte)2, byteBuffer, true);
        this.stateMachine.complete(true);
    }

    public Future<Void> sendBytesByFuture(ByteBuffer byteBuffer) {
        FutureToSendHandler futureToSendHandler = new FutureToSendHandler(this.wsSession);
        this.sendBytesByCompletion(byteBuffer, futureToSendHandler);
        return futureToSendHandler;
    }

    public void sendBytesByCompletion(ByteBuffer byteBuffer, SendHandler sendHandler) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        if (sendHandler == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullHandler"));
        }
        StateUpdateSendHandler stateUpdateSendHandler = new StateUpdateSendHandler(sendHandler, this.stateMachine);
        this.stateMachine.binaryStart();
        this.startMessage((byte)2, byteBuffer, true, stateUpdateSendHandler);
    }

    public void sendPartialBytes(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        this.stateMachine.binaryPartialStart();
        this.sendMessageBlock((byte)2, byteBuffer, bl);
        this.stateMachine.complete(bl);
    }

    public void sendPing(ByteBuffer byteBuffer) throws IOException, IllegalArgumentException {
        if (byteBuffer.remaining() > 125) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.tooMuchData"));
        }
        this.sendMessageBlock((byte)9, byteBuffer, true);
    }

    public void sendPong(ByteBuffer byteBuffer) throws IOException, IllegalArgumentException {
        if (byteBuffer.remaining() > 125) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.tooMuchData"));
        }
        this.sendMessageBlock((byte)10, byteBuffer, true);
    }

    public void sendString(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        this.stateMachine.textStart();
        this.sendMessageBlock(CharBuffer.wrap(string), true);
    }

    public Future<Void> sendStringByFuture(String string) {
        FutureToSendHandler futureToSendHandler = new FutureToSendHandler(this.wsSession);
        this.sendStringByCompletion(string, futureToSendHandler);
        return futureToSendHandler;
    }

    public void sendStringByCompletion(String string, SendHandler sendHandler) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        if (sendHandler == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullHandler"));
        }
        this.stateMachine.textStart();
        TextMessageSendHandler textMessageSendHandler = new TextMessageSendHandler(sendHandler, CharBuffer.wrap(string), true, this.encoder, this.encoderBuffer, this);
        textMessageSendHandler.write();
    }

    public void sendPartialString(String string, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        this.stateMachine.textPartialStart();
        this.sendMessageBlock(CharBuffer.wrap(string), bl);
    }

    public OutputStream getSendStream() {
        this.stateMachine.streamStart();
        return new WsOutputStream(this);
    }

    public Writer getSendWriter() {
        this.stateMachine.writeStart();
        return new WsWriter(this);
    }

    void sendMessageBlock(CharBuffer charBuffer, boolean bl) throws IOException {
        long l = this.getTimeoutExpiry();
        boolean bl2 = false;
        while (!bl2) {
            this.encoderBuffer.clear();
            CoderResult coderResult = this.encoder.encode(charBuffer, this.encoderBuffer, true);
            if (coderResult.isError()) {
                throw new IllegalArgumentException(coderResult.toString());
            }
            bl2 = !coderResult.isOverflow();
            this.encoderBuffer.flip();
            this.sendMessageBlock((byte)1, this.encoderBuffer, bl && bl2, l);
        }
        this.stateMachine.complete(bl);
    }

    void sendMessageBlock(byte by, ByteBuffer byteBuffer, boolean bl) throws IOException {
        this.sendMessageBlock(by, byteBuffer, bl, this.getTimeoutExpiry());
    }

    private long getTimeoutExpiry() {
        long l = this.getBlockingSendTimeout();
        if (l < 0L) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() + l;
    }

    private void sendMessageBlock(byte by, ByteBuffer byteBuffer, boolean bl, long l) throws IOException {
        this.wsSession.updateLastActiveWrite();
        BlockingSendHandler blockingSendHandler = new BlockingSendHandler();
        List<MessagePart> list = new ArrayList<MessagePart>();
        list.add(new MessagePart(bl, 0, by, byteBuffer, blockingSendHandler, blockingSendHandler, l));
        list = this.transformation.sendMessagePart(list);
        if (list.size() == 0) {
            return;
        }
        long l2 = l - System.currentTimeMillis();
        try {
            if (!this.messagePartInProgress.tryAcquire(l2, TimeUnit.MILLISECONDS)) {
                String string = sm.getString("wsRemoteEndpoint.acquireTimeout");
                this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, string), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, string), true);
                throw new SocketTimeoutException(string);
            }
        }
        catch (InterruptedException interruptedException) {
            String string = sm.getString("wsRemoteEndpoint.sendInterrupt");
            this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, string), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, string), true);
            throw new IOException(string, interruptedException);
        }
        for (MessagePart messagePart : list) {
            try {
                this.writeMessagePart(messagePart);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.messagePartInProgress.release();
                this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, throwable.getMessage()), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, throwable.getMessage()), true);
                throw throwable;
            }
            if (!blockingSendHandler.getSendResult().isOK()) {
                this.messagePartInProgress.release();
                Throwable throwable = blockingSendHandler.getSendResult().getException();
                this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, throwable.getMessage()), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, throwable.getMessage()), true);
                throw new IOException(throwable);
            }
            this.fragmented = this.nextFragmented;
            this.text = this.nextText;
        }
        if (byteBuffer != null) {
            byteBuffer.clear();
        }
        this.endMessage(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMessage(byte by, ByteBuffer byteBuffer, boolean bl, SendHandler sendHandler) {
        this.wsSession.updateLastActiveWrite();
        List<MessagePart> list = new ArrayList<MessagePart>();
        list.add(new MessagePart(bl, 0, by, byteBuffer, this.intermediateMessageHandler, new EndMessageHandler(this, sendHandler), -1L));
        try {
            list = this.transformation.sendMessagePart(list);
        }
        catch (IOException iOException) {
            sendHandler.onResult(new SendResult((Throwable)iOException));
            return;
        }
        if (list.size() == 0) {
            sendHandler.onResult(new SendResult());
            return;
        }
        MessagePart messagePart = list.remove(0);
        boolean bl2 = false;
        Object object = this.messagePartLock;
        synchronized (object) {
            if (8 == messagePart.getOpCode() && this.getBatchingAllowed()) {
                this.log.warn((Object)sm.getString("wsRemoteEndpoint.flushOnCloseFailed"));
            }
            if (this.messagePartInProgress.tryAcquire()) {
                bl2 = true;
            } else {
                this.messagePartQueue.add(messagePart);
            }
            this.messagePartQueue.addAll(list);
        }
        if (bl2) {
            this.writeMessagePart(messagePart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endMessage(SendHandler sendHandler, SendResult sendResult) {
        boolean bl = false;
        MessagePart messagePart = null;
        Object object = this.messagePartLock;
        synchronized (object) {
            this.fragmented = this.nextFragmented;
            this.text = this.nextText;
            messagePart = this.messagePartQueue.poll();
            if (messagePart == null) {
                this.messagePartInProgress.release();
            } else if (!this.closed) {
                bl = true;
            }
        }
        if (bl) {
            this.writeMessagePart(messagePart);
        }
        this.wsSession.updateLastActiveWrite();
        if (sendHandler != null) {
            sendHandler.onResult(sendResult);
        }
    }

    void writeMessagePart(MessagePart messagePart) {
        boolean bl;
        if (this.closed) {
            throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closed"));
        }
        if (24 == messagePart.getOpCode()) {
            this.nextFragmented = this.fragmented;
            this.nextText = this.text;
            this.outputBuffer.flip();
            OutputBufferFlushSendHandler outputBufferFlushSendHandler = new OutputBufferFlushSendHandler(this.outputBuffer, messagePart.getEndHandler());
            this.doWrite(outputBufferFlushSendHandler, messagePart.getBlockingWriteTimeoutExpiry(), this.outputBuffer);
            return;
        }
        if (Util.isControl(messagePart.getOpCode())) {
            this.nextFragmented = this.fragmented;
            this.nextText = this.text;
            if (messagePart.getOpCode() == 8) {
                this.closed = true;
            }
            bl = true;
        } else {
            boolean bl2 = Util.isText(messagePart.getOpCode());
            if (this.fragmented) {
                if (this.text != bl2) {
                    throw new IllegalStateException(sm.getString("wsRemoteEndpoint.changeType"));
                }
                this.nextText = this.text;
                this.nextFragmented = !messagePart.isFin();
                bl = false;
            } else {
                if (messagePart.isFin()) {
                    this.nextFragmented = false;
                } else {
                    this.nextFragmented = true;
                    this.nextText = bl2;
                }
                bl = true;
            }
        }
        Object object = this.isMasked() ? Util.generateMask() : null;
        int n = messagePart.getPayload().remaining();
        this.headerBuffer.clear();
        WsRemoteEndpointImplBase.writeHeader(this.headerBuffer, messagePart.isFin(), messagePart.getRsv(), messagePart.getOpCode(), this.isMasked(), messagePart.getPayload(), object, bl);
        this.headerBuffer.flip();
        if (this.getBatchingAllowed() || this.isMasked()) {
            OutputBufferSendHandler outputBufferSendHandler = new OutputBufferSendHandler(messagePart.getEndHandler(), messagePart.getBlockingWriteTimeoutExpiry(), this.headerBuffer, messagePart.getPayload(), (byte[])object, this.outputBuffer, !this.getBatchingAllowed(), this);
            outputBufferSendHandler.write();
        } else {
            this.doWrite(messagePart.getEndHandler(), messagePart.getBlockingWriteTimeoutExpiry(), this.headerBuffer, messagePart.getPayload());
        }
        this.updateStats(n);
    }

    protected void updateStats(long l) {
    }

    private long getBlockingSendTimeout() {
        Object object = this.wsSession.getUserProperties().get("org.apache.tomcat.websocket.BLOCKING_SEND_TIMEOUT");
        Long l = null;
        if (object instanceof Long) {
            l = (Long)object;
        }
        if (l == null) {
            return 20000L;
        }
        return l;
    }

    public void sendObject(Object object) throws IOException, EncodeException {
        if (object == null) {
            throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
        }
        Encoder encoder = this.findEncoder(object);
        if (encoder == null && Util.isPrimitive(object.getClass())) {
            String string = object.toString();
            this.sendString(string);
            return;
        }
        if (encoder == null && byte[].class.isAssignableFrom(object.getClass())) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
            this.sendBytes(byteBuffer);
            return;
        }
        if (encoder instanceof Encoder.Text) {
            String string = ((Encoder.Text)encoder).encode(object);
            this.sendString(string);
        } else if (encoder instanceof Encoder.TextStream) {
            try (Writer writer = this.getSendWriter();){
                ((Encoder.TextStream)encoder).encode(object, writer);
            }
        } else if (encoder instanceof Encoder.Binary) {
            ByteBuffer byteBuffer = ((Encoder.Binary)encoder).encode(object);
            this.sendBytes(byteBuffer);
        } else if (encoder instanceof Encoder.BinaryStream) {
            try (OutputStream outputStream = this.getSendStream();){
                ((Encoder.BinaryStream)encoder).encode(object, outputStream);
            }
        } else {
            throw new EncodeException(object, sm.getString("wsRemoteEndpoint.noEncoder", new Object[]{object.getClass()}));
        }
    }

    public Future<Void> sendObjectByFuture(Object object) {
        FutureToSendHandler futureToSendHandler = new FutureToSendHandler(this.wsSession);
        this.sendObjectByCompletion(object, futureToSendHandler);
        return futureToSendHandler;
    }

    public void sendObjectByCompletion(Object object, SendHandler sendHandler) {
        block34: {
            if (object == null) {
                throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullData"));
            }
            if (sendHandler == null) {
                throw new IllegalArgumentException(sm.getString("wsRemoteEndpoint.nullHandler"));
            }
            Encoder encoder = this.findEncoder(object);
            if (encoder == null && Util.isPrimitive(object.getClass())) {
                String string = object.toString();
                this.sendStringByCompletion(string, sendHandler);
                return;
            }
            if (encoder == null && byte[].class.isAssignableFrom(object.getClass())) {
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
                this.sendBytesByCompletion(byteBuffer, sendHandler);
                return;
            }
            try {
                if (encoder instanceof Encoder.Text) {
                    String string = ((Encoder.Text)encoder).encode(object);
                    this.sendStringByCompletion(string, sendHandler);
                    break block34;
                }
                if (encoder instanceof Encoder.TextStream) {
                    try (Writer writer = this.getSendWriter();){
                        ((Encoder.TextStream)encoder).encode(object, writer);
                    }
                    sendHandler.onResult(new SendResult());
                    break block34;
                }
                if (encoder instanceof Encoder.Binary) {
                    ByteBuffer byteBuffer = ((Encoder.Binary)encoder).encode(object);
                    this.sendBytesByCompletion(byteBuffer, sendHandler);
                    break block34;
                }
                if (encoder instanceof Encoder.BinaryStream) {
                    try (OutputStream outputStream = this.getSendStream();){
                        ((Encoder.BinaryStream)encoder).encode(object, outputStream);
                    }
                    sendHandler.onResult(new SendResult());
                    break block34;
                }
                throw new EncodeException(object, sm.getString("wsRemoteEndpoint.noEncoder", new Object[]{object.getClass()}));
            }
            catch (Exception exception) {
                SendResult sendResult = new SendResult((Throwable)exception);
                sendHandler.onResult(sendResult);
            }
        }
    }

    protected void setSession(WsSession wsSession) {
        this.wsSession = wsSession;
    }

    protected void setEncoders(EndpointConfig endpointConfig) throws DeploymentException {
        this.encoderEntries.clear();
        for (Class clazz : endpointConfig.getEncoders()) {
            Encoder encoder;
            InstanceManager instanceManager = this.wsSession.getInstanceManager();
            try {
                encoder = instanceManager == null ? (Encoder)clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : (Encoder)instanceManager.newInstance(clazz);
                encoder.init(endpointConfig);
            }
            catch (ReflectiveOperationException | NamingException exception) {
                throw new DeploymentException(sm.getString("wsRemoteEndpoint.invalidEncoder", new Object[]{clazz.getName()}), (Throwable)exception);
            }
            EncoderEntry encoderEntry = new EncoderEntry(Util.getEncoderType(clazz), encoder);
            this.encoderEntries.add(encoderEntry);
        }
    }

    private Encoder findEncoder(Object object) {
        for (EncoderEntry encoderEntry : this.encoderEntries) {
            if (!encoderEntry.getClazz().isAssignableFrom(object.getClass())) continue;
            return encoderEntry.getEncoder();
        }
        return null;
    }

    public final void close() {
        InstanceManager instanceManager = this.wsSession.getInstanceManager();
        for (EncoderEntry encoderEntry : this.encoderEntries) {
            encoderEntry.getEncoder().destroy();
            if (instanceManager == null) continue;
            try {
                instanceManager.destroyInstance((Object)encoderEntry);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                this.log.warn((Object)sm.getString("wsRemoteEndpoint.encoderDestoryFailed", new Object[]{this.encoder.getClass()}), (Throwable)reflectiveOperationException);
            }
        }
        this.transformation.close();
        this.doClose();
    }

    protected abstract void doWrite(SendHandler var1, long var2, ByteBuffer ... var4);

    protected abstract boolean isMasked();

    protected abstract void doClose();

    private static void writeHeader(ByteBuffer byteBuffer, boolean bl, int n, byte by, boolean bl2, ByteBuffer byteBuffer2, byte[] byArray, boolean bl3) {
        int n2 = 0;
        if (bl) {
            n2 = (byte)(n2 - 128);
        }
        n2 = (byte)(n2 + (n << 4));
        if (bl3) {
            n2 = (byte)(n2 + by);
        }
        byteBuffer.put((byte)n2);
        n2 = bl2 ? -128 : 0;
        if (byteBuffer2.remaining() < 126) {
            byteBuffer.put((byte)(byteBuffer2.remaining() | n2));
        } else if (byteBuffer2.remaining() < 65536) {
            byteBuffer.put((byte)(0x7E | n2));
            byteBuffer.put((byte)(byteBuffer2.remaining() >>> 8));
            byteBuffer.put((byte)(byteBuffer2.remaining() & 0xFF));
        } else {
            byteBuffer.put((byte)(0x7F | n2));
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(byteBuffer2.remaining() >>> 24));
            byteBuffer.put((byte)(byteBuffer2.remaining() >>> 16));
            byteBuffer.put((byte)(byteBuffer2.remaining() >>> 8));
            byteBuffer.put((byte)(byteBuffer2.remaining() & 0xFF));
        }
        if (bl2) {
            byteBuffer.put(byArray[0]);
            byteBuffer.put(byArray[1]);
            byteBuffer.put(byArray[2]);
            byteBuffer.put(byArray[3]);
        }
    }

    private static class BlockingSendHandler
    implements SendHandler {
        private volatile SendResult sendResult = null;

        private BlockingSendHandler() {
        }

        public void onResult(SendResult sendResult) {
            this.sendResult = sendResult;
        }

        public SendResult getSendResult() {
            return this.sendResult;
        }
    }

    private static class StateUpdateSendHandler
    implements SendHandler {
        private final SendHandler handler;
        private final StateMachine stateMachine;

        public StateUpdateSendHandler(SendHandler sendHandler, StateMachine stateMachine) {
            this.handler = sendHandler;
            this.stateMachine = stateMachine;
        }

        public void onResult(SendResult sendResult) {
            if (sendResult.isOK()) {
                this.stateMachine.complete(true);
            }
            this.handler.onResult(sendResult);
        }
    }

    private static class StateMachine {
        private State state = State.OPEN;

        private StateMachine() {
        }

        public synchronized void streamStart() {
            this.checkState(State.OPEN);
            this.state = State.STREAM_WRITING;
        }

        public synchronized void writeStart() {
            this.checkState(State.OPEN);
            this.state = State.WRITER_WRITING;
        }

        public synchronized void binaryPartialStart() {
            this.checkState(State.OPEN, State.BINARY_PARTIAL_READY);
            this.state = State.BINARY_PARTIAL_WRITING;
        }

        public synchronized void binaryStart() {
            this.checkState(State.OPEN);
            this.state = State.BINARY_FULL_WRITING;
        }

        public synchronized void textPartialStart() {
            this.checkState(State.OPEN, State.TEXT_PARTIAL_READY);
            this.state = State.TEXT_PARTIAL_WRITING;
        }

        public synchronized void textStart() {
            this.checkState(State.OPEN);
            this.state = State.TEXT_FULL_WRITING;
        }

        public synchronized void complete(boolean bl) {
            if (bl) {
                this.checkState(State.TEXT_PARTIAL_WRITING, State.TEXT_FULL_WRITING, State.BINARY_PARTIAL_WRITING, State.BINARY_FULL_WRITING, State.STREAM_WRITING, State.WRITER_WRITING);
                this.state = State.OPEN;
            } else {
                this.checkState(State.TEXT_PARTIAL_WRITING, State.BINARY_PARTIAL_WRITING, State.STREAM_WRITING, State.WRITER_WRITING);
                if (this.state == State.TEXT_PARTIAL_WRITING) {
                    this.state = State.TEXT_PARTIAL_READY;
                } else if (this.state == State.BINARY_PARTIAL_WRITING) {
                    this.state = State.BINARY_PARTIAL_READY;
                } else if (this.state != State.WRITER_WRITING && this.state != State.STREAM_WRITING) {
                    throw new IllegalStateException("BUG: This code should never be called");
                }
            }
        }

        private void checkState(State ... stateArray) {
            for (State state : stateArray) {
                if (this.state != state) continue;
                return;
            }
            throw new IllegalStateException(sm.getString("wsRemoteEndpoint.wrongState", new Object[]{this.state}));
        }
    }

    private static enum State {
        OPEN,
        STREAM_WRITING,
        WRITER_WRITING,
        BINARY_PARTIAL_WRITING,
        BINARY_PARTIAL_READY,
        BINARY_FULL_WRITING,
        TEXT_PARTIAL_WRITING,
        TEXT_PARTIAL_READY,
        TEXT_FULL_WRITING;

    }

    private static class EncoderEntry {
        private final Class<?> clazz;
        private final Encoder encoder;

        public EncoderEntry(Class<?> clazz, Encoder encoder) {
            this.clazz = clazz;
            this.encoder = encoder;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Encoder getEncoder() {
            return this.encoder;
        }
    }

    private static class WsWriter
    extends Writer {
        private final WsRemoteEndpointImplBase endpoint;
        private final CharBuffer buffer = CharBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
        private final Object closeLock = new Object();
        private volatile boolean closed = false;
        private volatile boolean used = false;

        public WsWriter(WsRemoteEndpointImplBase wsRemoteEndpointImplBase) {
            this.endpoint = wsRemoteEndpointImplBase;
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closedWriter"));
            }
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.used = true;
            if (n2 == 0) {
                return;
            }
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
            int n3 = this.buffer.remaining();
            int n4 = 0;
            while (n3 < n2 - n4) {
                this.buffer.put(cArray, n + n4, n3);
                n4 += n3;
                this.flush();
                n3 = this.buffer.remaining();
            }
            this.buffer.put(cArray, n + n4, n2 - n4);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closedWriter"));
            }
            if (this.buffer.position() > 0) {
                this.doWrite(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.doWrite(true);
        }

        private void doWrite(boolean bl) throws IOException {
            if (this.used) {
                this.buffer.flip();
                this.endpoint.sendMessageBlock(this.buffer, bl);
                this.buffer.clear();
            } else {
                this.endpoint.stateMachine.complete(bl);
            }
        }
    }

    private static class WsOutputStream
    extends OutputStream {
        private final WsRemoteEndpointImplBase endpoint;
        private final ByteBuffer buffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
        private final Object closeLock = new Object();
        private volatile boolean closed = false;
        private volatile boolean used = false;

        public WsOutputStream(WsRemoteEndpointImplBase wsRemoteEndpointImplBase) {
            this.endpoint = wsRemoteEndpointImplBase;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closedOutputStream"));
            }
            this.used = true;
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
            this.buffer.put((byte)n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closedOutputStream"));
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.used = true;
            if (n2 == 0) {
                return;
            }
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
            int n3 = this.buffer.remaining();
            int n4 = 0;
            while (n3 < n2 - n4) {
                this.buffer.put(byArray, n + n4, n3);
                n4 += n3;
                this.flush();
                n3 = this.buffer.remaining();
            }
            this.buffer.put(byArray, n + n4, n2 - n4);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("wsRemoteEndpoint.closedOutputStream"));
            }
            if (this.buffer.position() > 0) {
                this.doWrite(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.doWrite(true);
        }

        private void doWrite(boolean bl) throws IOException {
            if (this.used) {
                this.buffer.flip();
                this.endpoint.sendMessageBlock((byte)2, this.buffer, bl);
            }
            this.endpoint.stateMachine.complete(bl);
            this.buffer.clear();
        }
    }

    private static class OutputBufferFlushSendHandler
    implements SendHandler {
        private final ByteBuffer outputBuffer;
        private final SendHandler handler;

        public OutputBufferFlushSendHandler(ByteBuffer byteBuffer, SendHandler sendHandler) {
            this.outputBuffer = byteBuffer;
            this.handler = sendHandler;
        }

        public void onResult(SendResult sendResult) {
            if (sendResult.isOK()) {
                this.outputBuffer.clear();
            }
            this.handler.onResult(sendResult);
        }
    }

    private static class OutputBufferSendHandler
    implements SendHandler {
        private final SendHandler handler;
        private final long blockingWriteTimeoutExpiry;
        private final ByteBuffer headerBuffer;
        private final ByteBuffer payload;
        private final byte[] mask;
        private final ByteBuffer outputBuffer;
        private final boolean flushRequired;
        private final WsRemoteEndpointImplBase endpoint;
        private volatile int maskIndex = 0;

        public OutputBufferSendHandler(SendHandler sendHandler, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] byArray, ByteBuffer byteBuffer3, boolean bl, WsRemoteEndpointImplBase wsRemoteEndpointImplBase) {
            this.blockingWriteTimeoutExpiry = l;
            this.handler = sendHandler;
            this.headerBuffer = byteBuffer;
            this.payload = byteBuffer2;
            this.mask = byArray;
            this.outputBuffer = byteBuffer3;
            this.flushRequired = bl;
            this.endpoint = wsRemoteEndpointImplBase;
        }

        public void write() {
            while (this.headerBuffer.hasRemaining() && this.outputBuffer.hasRemaining()) {
                this.outputBuffer.put(this.headerBuffer.get());
            }
            if (this.headerBuffer.hasRemaining()) {
                this.outputBuffer.flip();
                this.endpoint.doWrite(this, this.blockingWriteTimeoutExpiry, this.outputBuffer);
                return;
            }
            int n = this.payload.remaining();
            int n2 = this.payload.limit();
            int n3 = this.outputBuffer.remaining();
            int n4 = n;
            if (n > n3) {
                n4 = n3;
                this.payload.limit(this.payload.position() + n4);
            }
            if (this.mask == null) {
                this.outputBuffer.put(this.payload);
            } else {
                for (int i = 0; i < n4; ++i) {
                    this.outputBuffer.put((byte)(this.payload.get() ^ this.mask[this.maskIndex++] & 0xFF));
                    if (this.maskIndex <= 3) continue;
                    this.maskIndex = 0;
                }
            }
            if (n > n3) {
                this.payload.limit(n2);
                this.outputBuffer.flip();
                this.endpoint.doWrite(this, this.blockingWriteTimeoutExpiry, this.outputBuffer);
                return;
            }
            if (this.flushRequired) {
                this.outputBuffer.flip();
                if (this.outputBuffer.remaining() == 0) {
                    this.handler.onResult(SENDRESULT_OK);
                } else {
                    this.endpoint.doWrite(this, this.blockingWriteTimeoutExpiry, this.outputBuffer);
                }
            } else {
                this.handler.onResult(SENDRESULT_OK);
            }
        }

        public void onResult(SendResult sendResult) {
            if (sendResult.isOK()) {
                if (this.outputBuffer.hasRemaining()) {
                    this.endpoint.doWrite(this, this.blockingWriteTimeoutExpiry, this.outputBuffer);
                } else {
                    this.outputBuffer.clear();
                    this.write();
                }
            } else {
                this.handler.onResult(sendResult);
            }
        }
    }

    private class TextMessageSendHandler
    implements SendHandler {
        private final SendHandler handler;
        private final CharBuffer message;
        private final boolean isLast;
        private final CharsetEncoder encoder;
        private final ByteBuffer buffer;
        private final WsRemoteEndpointImplBase endpoint;
        private volatile boolean isDone = false;

        public TextMessageSendHandler(SendHandler sendHandler, CharBuffer charBuffer, boolean bl, CharsetEncoder charsetEncoder, ByteBuffer byteBuffer, WsRemoteEndpointImplBase wsRemoteEndpointImplBase2) {
            this.handler = sendHandler;
            this.message = charBuffer;
            this.isLast = bl;
            this.encoder = charsetEncoder.reset();
            this.buffer = byteBuffer;
            this.endpoint = wsRemoteEndpointImplBase2;
        }

        public void write() {
            this.buffer.clear();
            CoderResult coderResult = this.encoder.encode(this.message, this.buffer, true);
            if (coderResult.isError()) {
                throw new IllegalArgumentException(coderResult.toString());
            }
            this.isDone = !coderResult.isOverflow();
            this.buffer.flip();
            this.endpoint.startMessage((byte)1, this.buffer, this.isDone && this.isLast, this);
        }

        public void onResult(SendResult sendResult) {
            if (this.isDone) {
                this.endpoint.stateMachine.complete(this.isLast);
                this.handler.onResult(sendResult);
            } else if (!sendResult.isOK()) {
                this.handler.onResult(sendResult);
            } else if (WsRemoteEndpointImplBase.this.closed) {
                SendResult sendResult2 = new SendResult((Throwable)new IOException(sm.getString("wsRemoteEndpoint.closedDuringMessage")));
                this.handler.onResult(sendResult2);
            } else {
                this.write();
            }
        }
    }

    private static class IntermediateMessageHandler
    implements SendHandler {
        private final WsRemoteEndpointImplBase endpoint;

        public IntermediateMessageHandler(WsRemoteEndpointImplBase wsRemoteEndpointImplBase) {
            this.endpoint = wsRemoteEndpointImplBase;
        }

        public void onResult(SendResult sendResult) {
            this.endpoint.endMessage(null, sendResult);
        }
    }

    private static class EndMessageHandler
    implements SendHandler {
        private final WsRemoteEndpointImplBase endpoint;
        private final SendHandler handler;

        public EndMessageHandler(WsRemoteEndpointImplBase wsRemoteEndpointImplBase, SendHandler sendHandler) {
            this.endpoint = wsRemoteEndpointImplBase;
            this.handler = sendHandler;
        }

        public void onResult(SendResult sendResult) {
            this.endpoint.endMessage(this.handler, sendResult);
        }
    }
}

