/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.LambdaExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.ELParserTreeConstants;
import org.apache.el.parser.Node;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int n) {
        super(n);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return method.getReturnType();
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object[] objectArray;
        VariableMapper variableMapper;
        Object object;
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null && this.prefix.length() == 0) {
            object = null;
            if (evaluationContext.isLambdaArgument(this.localName)) {
                object = evaluationContext.getLambdaArgument(this.localName);
            }
            if (object == null && (variableMapper = evaluationContext.getVariableMapper()) != null && (object = variableMapper.resolveVariable(this.localName)) instanceof ValueExpression) {
                object = ((ValueExpression)object).getValue((ELContext)evaluationContext);
            }
            if (object == null) {
                object = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.localName);
            }
            if (object instanceof LambdaExpression) {
                int n;
                for (n = 0; object instanceof LambdaExpression && n < this.jjtGetNumChildren(); ++n) {
                    Node node = this.jjtGetChild(n);
                    object = ((LambdaExpression)object).invoke(((AstMethodParameters)node).getParameters(evaluationContext));
                }
                if (n < this.jjtGetNumChildren()) {
                    throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
                }
                return object;
            }
            object = evaluationContext.getImportHandler().resolveClass(this.localName);
            if (object != null) {
                return evaluationContext.getELResolver().invoke((ELContext)evaluationContext, (Object)new ELClass((Class)object), (Object)"<init>", null, ((AstMethodParameters)this.children[0]).getParameters(evaluationContext));
            }
            object = evaluationContext.getImportHandler().resolveStatic(this.localName);
            if (object != null) {
                return evaluationContext.getELResolver().invoke((ELContext)evaluationContext, (Object)new ELClass((Class)object), (Object)this.localName, null, ((AstMethodParameters)this.children[0]).getParameters(evaluationContext));
            }
        }
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        if (this.jjtGetNumChildren() != 1) {
            throw new ELException(MessageFactory.get("error.function.tooManyMethodParameterSets", this.getOutputName()));
        }
        object = this.jjtGetChild(0);
        variableMapper = method.getParameterTypes();
        Object[] objectArray2 = null;
        Object object2 = null;
        int n = object.jjtGetNumChildren();
        int n2 = ((VariableMapper)variableMapper).length;
        if (n == 0 && n2 == 1 && method.isVarArgs()) {
            objectArray2 = new Object[]{null};
        } else if (n > 0) {
            objectArray2 = new Object[n2];
            try {
                for (int i = 0; i < n2; ++i) {
                    if (method.isVarArgs() && i == n2 - 1) {
                        if (n < n2) {
                            objectArray2[i] = new Object[]{null};
                        } else if (n == n2 && variableMapper[i].isArray()) {
                            objectArray2[i] = object.jjtGetChild(i).getValue(evaluationContext);
                        } else {
                            objectArray = new Object[n - n2 + 1];
                            Class<?> clazz = variableMapper[i].getComponentType();
                            for (int j = i; j < n; ++j) {
                                objectArray[j - i] = object.jjtGetChild(j).getValue(evaluationContext);
                                objectArray[j - i] = AstFunction.coerceToType(evaluationContext, objectArray[j - i], clazz);
                            }
                            objectArray2[i] = objectArray;
                        }
                    } else {
                        objectArray2[i] = object.jjtGetChild(i).getValue(evaluationContext);
                    }
                    objectArray2[i] = AstFunction.coerceToType(evaluationContext, objectArray2[i], variableMapper[i]);
                }
            }
            catch (ELException eLException) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)eLException);
            }
        }
        try {
            object2 = method.invoke(null, objectArray2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            objectArray = invocationTargetException.getCause();
            if (objectArray instanceof ThreadDeath) {
                throw (ThreadDeath)objectArray;
            }
            if (objectArray instanceof VirtualMachineError) {
                throw (VirtualMachineError)objectArray;
            }
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)objectArray);
        }
        return object2;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

