/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;

abstract class AbstractLongMap {
    private final int VALUE_SIZE;
    final int ENTRY_SIZE;
    private File tempFile;
    long fileSize;
    private long keys;
    final int KEY_SIZE;
    final int ID_SIZE;
    final int FOFFSET_SIZE;
    Data dumpBuffer;
    CacheDirectory cacheDirectory;

    AbstractLongMap(int size, int idSize, int foffsetSize, int valueSize, CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        assert (idSize == 4 || idSize == 8);
        assert (foffsetSize == 4 || foffsetSize == 8);
        this.keys = (long)size * 4L / 3L;
        this.ID_SIZE = idSize;
        this.FOFFSET_SIZE = foffsetSize;
        this.KEY_SIZE = this.ID_SIZE;
        this.VALUE_SIZE = valueSize;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        this.tempFile = cacheDir.createTempFile("NBProfiler", ".map");
        RandomAccessFile file = new RandomAccessFile(this.tempFile, "rw");
        if (Boolean.getBoolean("org.graalvm.visualvm.lib.jfluid.heap.zerofile")) {
            byte[] zeros = new byte[524288];
            while (file.length() < this.fileSize) {
                file.write(zeros);
            }
            file.write(zeros, 0, (int)(this.fileSize - file.length()));
        }
        file.setLength(this.fileSize);
        this.setDumpBuffer(file);
        file.close();
        this.cacheDirectory = cacheDir;
    }

    protected void finalize() throws Throwable {
        if (this.cacheDirectory.isTemporary()) {
            this.tempFile.delete();
        }
        super.finalize();
    }

    Entry get(long key) {
        long index = this.getIndex(key);
        long mapKey;
        while ((mapKey = this.getID(index)) != key) {
            if (mapKey == 0L) {
                return null;
            }
            index = this.getNextIndex(index);
        }
        return this.createEntry(index);
    }

    Entry put(long key, long value) {
        long index = this.getIndex(key);
        while (true) {
            long mapKey;
            if ((mapKey = this.getID(index)) == 0L) {
                this.putID(index, key);
                return this.createEntry(index, value);
            }
            if (mapKey == key) {
                return this.createEntry(index);
            }
            index = this.getNextIndex(index);
        }
    }

    private void setDumpBuffer(RandomAccessFile file) throws IOException {
        long length = file.length();
        try {
            this.dumpBuffer = length > Integer.MAX_VALUE ? new LongMemoryMappedData(file, length, this.ENTRY_SIZE) : new MemoryMappedData(file, length);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof OutOfMemoryError) {
                this.dumpBuffer = new FileData(file, length);
            }
            throw ex;
        }
    }

    long getID(long index) {
        if (this.ID_SIZE == 4) {
            return (long)this.dumpBuffer.getInt(index) & 0xFFFFFFFFL;
        }
        return this.dumpBuffer.getLong(index);
    }

    void putID(long index, long key) {
        if (this.ID_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    long getFoffset(long index) {
        if (this.FOFFSET_SIZE == 4) {
            return this.dumpBuffer.getInt(index);
        }
        return this.dumpBuffer.getLong(index);
    }

    void putFoffset(long index, long key) {
        if (this.FOFFSET_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeLong(this.keys);
        out.writeInt(this.ID_SIZE);
        out.writeInt(this.FOFFSET_SIZE);
        out.writeInt(this.VALUE_SIZE);
        out.writeUTF(this.tempFile.getAbsolutePath());
        this.dumpBuffer.force(this.tempFile);
    }

    AbstractLongMap(DataInputStream dis, CacheDirectory cacheDir) throws IOException {
        this.keys = dis.readLong();
        this.ID_SIZE = dis.readInt();
        this.FOFFSET_SIZE = dis.readInt();
        this.VALUE_SIZE = dis.readInt();
        this.tempFile = cacheDir.getCacheFile(dis.readUTF());
        this.KEY_SIZE = this.ID_SIZE;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        RandomAccessFile file = new RandomAccessFile(this.tempFile, "rw");
        this.setDumpBuffer(file);
        file.close();
        this.cacheDirectory = cacheDir;
    }

    private long getIndex(long key) {
        long hash = key & Long.MAX_VALUE;
        return hash % this.keys * (long)this.ENTRY_SIZE;
    }

    private long getNextIndex(long index) {
        if ((index += (long)this.ENTRY_SIZE) >= this.fileSize) {
            index = 0L;
        }
        return index;
    }

    private static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.endsWith("Linux");
    }

    abstract Entry createEntry(long var1);

    abstract Entry createEntry(long var1, long var3);

    static /* synthetic */ boolean access$000() {
        return AbstractLongMap.isLinux();
    }

    private static class LongMemoryMappedData
    implements Data {
        private static int BUFFER_SIZE_BITS = 30;
        private static long BUFFER_SIZE = 1L << BUFFER_SIZE_BITS;
        private static int BUFFER_SIZE_MASK = (int)(BUFFER_SIZE - 1L);
        private static int BUFFER_EXT = 32768;
        private MappedByteBuffer[] dumpBuffer;
        private final int entrySize;

        LongMemoryMappedData(RandomAccessFile file, long length, int entry) throws IOException {
            this.dumpBuffer = LongMemoryMappedData.createBuffers(file, length);
            this.entrySize = entry;
        }

        @Override
        public byte getByte(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].get(this.getBufferOffset(index));
        }

        @Override
        public int getInt(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].getInt(this.getBufferOffset(index));
        }

        @Override
        public long getLong(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].getLong(this.getBufferOffset(index));
        }

        @Override
        public void putByte(long index, byte data) {
            this.dumpBuffer[this.getBufferIndex(index)].put(this.getBufferOffset(index), data);
        }

        @Override
        public void putInt(long index, int data) {
            this.dumpBuffer[this.getBufferIndex(index)].putInt(this.getBufferOffset(index), data);
        }

        @Override
        public void putLong(long index, long data) {
            this.dumpBuffer[this.getBufferIndex(index)].putLong(this.getBufferOffset(index), data);
        }

        private int getBufferIndex(long index) {
            return (int)(index >> BUFFER_SIZE_BITS);
        }

        private int getBufferOffset(long index) {
            return (int)(index & (long)BUFFER_SIZE_MASK);
        }

        @Override
        public void force(File bufferFile) throws IOException {
            if (MemoryMappedData.MAP_MODE == FileChannel.MapMode.PRIVATE) {
                File newBufferFile = new File(bufferFile.getAbsolutePath() + ".new");
                long length = bufferFile.length();
                FileChannel channel = new FileOutputStream(newBufferFile).getChannel();
                int offset_start = 0;
                for (int i = 0; i < this.dumpBuffer.length; ++i) {
                    MappedByteBuffer buf = this.dumpBuffer[i];
                    long offset_end = (long)(i + 1) * BUFFER_SIZE / (long)this.entrySize * (long)this.entrySize + (long)this.entrySize;
                    if (offset_end > length) {
                        offset_end = length;
                    }
                    buf.limit((int)(offset_end - (long)i * BUFFER_SIZE));
                    buf.position(offset_start);
                    channel.write(buf);
                    offset_start = (int)(offset_end - (long)(i + 1) * BUFFER_SIZE);
                }
                channel.close();
                this.dumpBuffer = null;
                bufferFile.delete();
                newBufferFile.renameTo(bufferFile);
                this.dumpBuffer = LongMemoryMappedData.createBuffers(new RandomAccessFile(bufferFile, "rw"), length);
            } else {
                for (MappedByteBuffer buf : this.dumpBuffer) {
                    buf.force();
                }
            }
        }

        private static MappedByteBuffer[] createBuffers(RandomAccessFile file, long length) throws IOException {
            FileChannel channel = file.getChannel();
            MappedByteBuffer[] dumpBuffer = new MappedByteBuffer[(int)((length + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
            for (int i = 0; i < dumpBuffer.length; ++i) {
                long position = (long)i * BUFFER_SIZE;
                long size = Math.min(BUFFER_SIZE + (long)BUFFER_EXT, length - position);
                dumpBuffer[i] = channel.map(MemoryMappedData.MAP_MODE, position, size);
            }
            channel.close();
            file.close();
            return dumpBuffer;
        }
    }

    private static class MemoryMappedData
    implements Data {
        private static final FileChannel.MapMode MAP_MODE = AbstractLongMap.access$000() ? FileChannel.MapMode.PRIVATE : FileChannel.MapMode.READ_WRITE;
        MappedByteBuffer buf;

        MemoryMappedData(RandomAccessFile file, long length) throws IOException {
            this.buf = MemoryMappedData.createBuffer(file, length);
        }

        @Override
        public byte getByte(long index) {
            return this.buf.get((int)index);
        }

        @Override
        public int getInt(long index) {
            return this.buf.getInt((int)index);
        }

        @Override
        public long getLong(long index) {
            return this.buf.getLong((int)index);
        }

        @Override
        public void putByte(long index, byte data) {
            this.buf.put((int)index, data);
        }

        @Override
        public void putInt(long index, int data) {
            this.buf.putInt((int)index, data);
        }

        @Override
        public void putLong(long index, long data) {
            this.buf.putLong((int)index, data);
        }

        @Override
        public void force(File bufferFile) throws IOException {
            if (MAP_MODE == FileChannel.MapMode.PRIVATE) {
                File newBufferFile = new File(bufferFile.getAbsolutePath() + ".new");
                int length = this.buf.capacity();
                new FileOutputStream(newBufferFile).getChannel().write(this.buf);
                this.buf = null;
                bufferFile.delete();
                newBufferFile.renameTo(bufferFile);
                this.buf = MemoryMappedData.createBuffer(new RandomAccessFile(bufferFile, "rw"), length);
            } else {
                this.buf.force();
            }
        }

        private static MappedByteBuffer createBuffer(RandomAccessFile file, long length) throws IOException {
            FileChannel channel = file.getChannel();
            MappedByteBuffer buf = channel.map(MAP_MODE, 0L, length);
            channel.close();
            return buf;
        }
    }

    private class FileData
    implements Data {
        RandomAccessFile file;
        byte[] buf;
        boolean bufferModified;
        long offset;
        static final int BUFFER_SIZE = 128;

        FileData(RandomAccessFile f, long length) throws IOException {
            this.file = f;
            this.buf = new byte[AbstractLongMap.this.ENTRY_SIZE * 128];
        }

        @Override
        public synchronized byte getByte(long index) {
            int i = this.loadBufferIfNeeded(index);
            return this.buf[i];
        }

        @Override
        public synchronized int getInt(long index) {
            int i = this.loadBufferIfNeeded(index);
            int ch1 = this.buf[i++] & 0xFF;
            int ch2 = this.buf[i++] & 0xFF;
            int ch3 = this.buf[i++] & 0xFF;
            int ch4 = this.buf[i] & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        @Override
        public synchronized long getLong(long index) {
            int i = this.loadBufferIfNeeded(index);
            return ((long)this.buf[i++] << 56) + ((long)(this.buf[i++] & 0xFF) << 48) + ((long)(this.buf[i++] & 0xFF) << 40) + ((long)(this.buf[i++] & 0xFF) << 32) + ((long)(this.buf[i++] & 0xFF) << 24) + (long)((this.buf[i++] & 0xFF) << 16) + (long)((this.buf[i++] & 0xFF) << 8) + (long)((this.buf[i++] & 0xFF) << 0);
        }

        @Override
        public synchronized void putByte(long index, byte data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i] = data;
            this.bufferModified = true;
        }

        @Override
        public synchronized void putInt(long index, int data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        @Override
        public synchronized void putLong(long index, long data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 56);
            this.buf[i++] = (byte)(data >>> 48);
            this.buf[i++] = (byte)(data >>> 40);
            this.buf[i++] = (byte)(data >>> 32);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        private int loadBufferIfNeeded(long index) {
            int i = (int)(index % (long)(AbstractLongMap.this.ENTRY_SIZE * 128));
            long newOffset = index - (long)i;
            if (this.offset != newOffset) {
                try {
                    this.flush();
                    this.file.seek(newOffset);
                    this.file.readFully(this.buf, 0, this.getBufferSize(newOffset));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.offset = newOffset;
            }
            return i;
        }

        private int getBufferSize(long off) {
            int size = this.buf.length;
            if (AbstractLongMap.this.fileSize - off < (long)this.buf.length) {
                size = (int)(AbstractLongMap.this.fileSize - off);
            }
            return size;
        }

        private void flush() throws IOException {
            if (this.bufferModified) {
                this.file.seek(this.offset);
                this.file.write(this.buf, 0, this.getBufferSize(this.offset));
                this.bufferModified = false;
            }
        }

        @Override
        public void force(File bufferFile) throws IOException {
            this.flush();
        }
    }

    static interface Data {
        public byte getByte(long var1);

        public int getInt(long var1);

        public long getLong(long var1);

        public void putByte(long var1, byte var3);

        public void putInt(long var1, int var3);

        public void putLong(long var1, long var3);

        public void force(File var1) throws IOException;
    }

    abstract class Entry {
        Entry() {
        }
    }
}

