/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.colour.ContinuousPointColourer;

public class AltitudeColourer
extends ContinuousPointColourer {
    public AltitudeColourer(Color color, Color color2) {
        super(color, color2);
    }

    @Override
    public void calculateColours(TrackInfo trackInfo) {
        double d;
        Track track = trackInfo == null ? null : trackInfo.getTrack();
        int n = track == null ? 0 : track.getNumPoints();
        DataPoint dataPoint = null;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            dataPoint = track.getPoint(n2);
            if (dataPoint != null && dataPoint.hasAltitude()) {
                d = dataPoint.getAltitude().getMetricValue();
                if (d < d2 || !bl) {
                    d2 = d;
                }
                if (d > d3 || !bl) {
                    d3 = d;
                }
                bl = true;
            }
            ++n2;
        }
        if (d3 - d2 < 1.0) {
            this.init(0);
        } else {
            this.init(n);
            n2 = 0;
            while (n2 < n) {
                dataPoint = track.getPoint(n2);
                if (dataPoint != null && dataPoint.hasAltitude() && !dataPoint.isWaypoint()) {
                    d = dataPoint.getAltitude().getMetricValue();
                    double d4 = (d - d2) / (d3 - d2);
                    this.setColour(n2, this.mixColour((float)d4));
                } else {
                    this.setColour(n2, null);
                }
                ++n2;
            }
        }
    }
}

