/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Override
    @Nullable
    protected abstract T compute();

    @Override
    @Nullable
    public T getValue() {
        boolean computed = this.myComputed;
        T value2 = this.myValue;
        if (!computed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
                this.myComputed = true;
            }
        }
        return value2;
    }

    public void drop() {
        this.myComputed = false;
        this.myValue = null;
    }

    @NotNull
    public static <T> VolatileNullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value2) {
        if (value2 == null) {
            VolatileNullableLazyValue.$$$reportNull$$$0(0);
        }
        return new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value2.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
    }
}

