/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.FullLayout;
import net.sourceforge.plantuml.classdiagram.RowLayout;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.svek.image.EntityImageClass;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private boolean allowMixing;
    private int useLayoutExplicit = 0;

    public ClassDiagram(ISkinSimple skinParam) {
        super(UmlDiagramType.CLASS, skinParam);
    }

    private Code getShortName1972(Code code) {
        String separator = Objects.requireNonNull(this.getNamespaceSeparator());
        String codeString = code.getName();
        String namespace = this.getNamespace1972(code, this.getNamespaceSeparator());
        if (namespace == null) {
            return this.buildCode(codeString);
        }
        return this.buildCode(codeString.substring(namespace.length() + separator.length()));
    }

    @Override
    public ILeaf getOrCreateLeaf(Ident ident, Code code, LeafType type, USymbol symbol) {
        Objects.requireNonNull(ident);
        if (this.V1972()) {
            if (type == null) {
                type = LeafType.CLASS;
            }
            return this.getOrCreateLeafDefault(ident, code, type, symbol);
        }
        if (type == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            if (this.getNamespaceSeparator() == null) {
                return this.getOrCreateLeafDefault(ident, code, LeafType.CLASS, symbol);
            }
            if (super.leafExist(code = this.getFullyQualifiedCode1972(code))) {
                return this.getOrCreateLeafDefault(ident, code, LeafType.CLASS, symbol);
            }
            return this.createEntityWithNamespace1972(ident, code, Display.getWithNewlines(ident.getLast()), LeafType.CLASS, symbol);
        }
        if (this.getNamespaceSeparator() == null) {
            return this.getOrCreateLeafDefault(ident, code, type, symbol);
        }
        if (super.leafExist(code = this.getFullyQualifiedCode1972(code))) {
            return this.getOrCreateLeafDefault(ident, code, type, symbol);
        }
        return this.createEntityWithNamespace1972(ident, code, Display.getWithNewlines(ident.getLast()), type, symbol);
    }

    @Override
    public ILeaf createLeaf(Ident idNewLong, Code code, Display display, LeafType type, USymbol symbol) {
        Objects.requireNonNull(idNewLong);
        if (type != LeafType.ABSTRACT_CLASS && type != LeafType.ANNOTATION && type != LeafType.CLASS && type != LeafType.INTERFACE && type != LeafType.ENUM && type != LeafType.LOLLIPOP_FULL && type != LeafType.LOLLIPOP_HALF && type != LeafType.NOTE) {
            return super.createLeaf(idNewLong, code, display, type, symbol);
        }
        if (this.V1972()) {
            return super.createLeaf(idNewLong, code, display, type, symbol);
        }
        if (this.getNamespaceSeparator() == null) {
            return super.createLeaf(idNewLong, code, display, type, symbol);
        }
        if (super.leafExist(code = this.getFullyQualifiedCode1972(code))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace1972(idNewLong, code, display, type, symbol);
    }

    private ILeaf createEntityWithNamespace1972(Ident id, Code fullyCode, Display display, LeafType type, USymbol symbol) {
        IGroup backupCurrentGroup;
        if (this.V1972()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(id);
        IGroup group = backupCurrentGroup = this.getCurrentGroup();
        String namespaceString = this.getNamespace1972(fullyCode, this.getNamespaceSeparator());
        if (namespaceString != null && (EntityUtils.groupRoot(group) || !group.getCodeGetName().equals(namespaceString))) {
            Code namespace = this.buildCode(namespaceString);
            Display tmp = Display.getWithNewlines(namespaceString);
            Ident newIdLong = this.buildLeafIdentSpecial(namespaceString);
            this.gotoGroupExternal(newIdLong, namespace, tmp, namespace, GroupType.PACKAGE, this.getRootGroup());
        }
        Display tmpDisplay = Display.isNull(display) ? Display.getWithNewlines(this.getShortName1972(fullyCode)).withCreoleMode(CreoleMode.SIMPLE_LINE) : display;
        ILeaf result = this.createLeafInternal(id, fullyCode, tmpDisplay, type, symbol);
        this.gotoThisGroup(backupCurrentGroup);
        return result;
    }

    @Override
    public final boolean leafExist(Code code) {
        if (this.getNamespaceSeparator() == null) {
            return super.leafExist(code);
        }
        return super.leafExist(this.getFullyQualifiedCode1972(code));
    }

    public void setAllowMixing(boolean allowMixing) {
        this.allowMixing = allowMixing;
    }

    public boolean isAllowMixing() {
        return this.allowMixing;
    }

    public void layoutNewLine() {
        ++this.useLayoutExplicit;
        this.incRawLayout();
    }

    @Override
    protected final ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        if (this.useLayoutExplicit != 0) {
            return this.exportLayoutExplicit(os, index, fileFormatOption);
        }
        return super.exportDiagramInternal(os, index, fileFormatOption);
    }

    protected final ImageData exportLayoutExplicit(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FullLayout fullLayout = new FullLayout();
        for (int i = 0; i <= this.useLayoutExplicit; ++i) {
            RowLayout rawLayout = this.getRawLayout(i);
            fullLayout.addRowLayout(rawLayout);
        }
        return this.createImageBuilder(fileFormatOption).annotations(false).drawable(fullLayout).write(os);
    }

    private RowLayout getRawLayout(int raw) {
        RowLayout rawLayout = new RowLayout();
        for (ILeaf leaf : this.entityFactory.leafs()) {
            if (leaf.getRawLayout() != raw) continue;
            rawLayout.addLeaf(this.getEntityImageClass(leaf));
        }
        return rawLayout;
    }

    private TextBlock getEntityImageClass(ILeaf entity) {
        return new EntityImageClass(null, entity, this.getSkinParam(), this);
    }

    @Override
    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            int len = link.getLength();
            if (len != 1) continue;
            for (Link link2 : this.getLinks()) {
                if (!link2.sameConnections(link) || link2.getLength() == 1) continue;
                link2.setLength(1);
            }
        }
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

