/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandMultilinesFooter
extends CommandMultilines<TitledDiagram> {
    public CommandMultilinesFooter() {
        super("(?i)^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim();
        Matcher2 m = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String align = m.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            HorizontalAlignment ha = HorizontalAlignment.fromString(align, HorizontalAlignment.CENTER);
            if (UseStyle.useBetaStyle() && align == null) {
                ha = FontParam.FOOTER.getStyleDefinition(null).getMergedStyle(((UmlDiagram)diagram).getSkinParam().getCurrentStyleBuilder()).getHorizontalAlignment();
            }
            diagram.getFooter().putDisplay(strings, ha);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

