/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public final class FactorySequenceNoteCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("POSITION", "(right|left|over)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTICIPANT", "(?:of[%s]+)?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("POSITION", "(right|left|over)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTICIPANT", "(?:of[%s])?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
                return FactorySequenceNoteCommand.this.executeInternal(diagram, arg, BlocLines.getWithNewlines(arg.get("NOTE", 0)));
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult arg, BlocLines strings) throws NoSuchColorException {
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("PARTICIPANT", 0)));
        NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0)));
        if (strings.size() > 0) {
            boolean tryMerge = arg.get("VMERGE", 0) != null;
            boolean parallel = arg.get("PARALLEL", 0) != null;
            Display display = diagram.manageVariable(strings.toDisplay());
            Note note = new Note(p, position, display, diagram.getSkinParam().getCurrentStyleBuilder());
            Colors colors = FactorySequenceNoteCommand.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
            String stereotypeString = arg.get("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = new Stereotype(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), FontParam.NOTE, ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setColors(colors);
            note.setNoteStyle(NoteStyle.getNoteStyle(arg.get("STYLE", 0)));
            if (arg.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                Url urlLink = urlBuilder.getUrl(arg.get("URL", 0));
                note.setUrl(urlLink);
            }
            if (parallel) {
                note.goParallel();
            }
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

