"""
The contents of this file are the return value of
``sympy.assumptions.ask.compute_known_facts``.

Do NOT manually edit this file.
Instead, run ./bin/ask_update.py.
"""

from sympy.core.cache import cacheit
from sympy.logic.boolalg import And
from sympy.assumptions.cnf import Literal
from sympy.assumptions.ask import Q

# -{ Known facts as a set }-
@cacheit
def get_all_known_facts():
    return {
        frozenset((Literal(Q.algebraic, False), Literal(Q.complex, True), Literal(Q.finite, True), Literal(Q.transcendental, False))),
        frozenset((Literal(Q.algebraic, False), Literal(Q.rational, True))),
        frozenset((Literal(Q.algebraic, True), Literal(Q.complex, False))),
        frozenset((Literal(Q.algebraic, True), Literal(Q.finite, False))),
        frozenset((Literal(Q.algebraic, True), Literal(Q.transcendental, True))),
        frozenset((Literal(Q.antihermitian, False), Literal(Q.imaginary, True))),
        frozenset((Literal(Q.antihermitian, True), Literal(Q.hermitian, True))),
        frozenset((Literal(Q.complex, False), Literal(Q.imaginary, True))),
        frozenset((Literal(Q.complex, False), Literal(Q.real, True))),
        frozenset((Literal(Q.complex, False), Literal(Q.transcendental, True))),
        frozenset((Literal(Q.complex_elements, False), Literal(Q.real_elements, True))),
        frozenset((Literal(Q.composite, True), Literal(Q.prime, True))),
        frozenset((Literal(Q.diagonal, False), Literal(Q.lower_triangular, True), Literal(Q.upper_triangular, True))),
        frozenset((Literal(Q.diagonal, True), Literal(Q.lower_triangular, False))),
        frozenset((Literal(Q.diagonal, True), Literal(Q.normal, False))),
        frozenset((Literal(Q.diagonal, True), Literal(Q.symmetric, False))),
        frozenset((Literal(Q.diagonal, True), Literal(Q.upper_triangular, False))),
        frozenset((Literal(Q.even, False), Literal(Q.integer, True), Literal(Q.odd, False))),
        frozenset((Literal(Q.even, False), Literal(Q.zero, True))),
        frozenset((Literal(Q.even, True), Literal(Q.integer, False))),
        frozenset((Literal(Q.even, True), Literal(Q.odd, True))),
        frozenset((Literal(Q.extended_real, False), Literal(Q.infinite, True))),
        frozenset((Literal(Q.extended_real, False), Literal(Q.real, True))),
        frozenset((Literal(Q.extended_real, True), Literal(Q.infinite, False), Literal(Q.real, False))),
        frozenset((Literal(Q.finite, False), Literal(Q.irrational, True))),
        frozenset((Literal(Q.finite, False), Literal(Q.rational, True))),
        frozenset((Literal(Q.finite, False), Literal(Q.transcendental, True))),
        frozenset((Literal(Q.finite, True), Literal(Q.infinite, True))),
        frozenset((Literal(Q.finite, True), Literal(Q.irrational, False), Literal(Q.rational, False), Literal(Q.real, True))),
        frozenset((Literal(Q.fullrank, False), Literal(Q.invertible, True))),
        frozenset((Literal(Q.fullrank, True), Literal(Q.invertible, False), Literal(Q.square, True))),
        frozenset((Literal(Q.hermitian, False), Literal(Q.real, True))),
        frozenset((Literal(Q.imaginary, True), Literal(Q.real, True))),
        frozenset((Literal(Q.integer, False), Literal(Q.odd, True))),
        frozenset((Literal(Q.integer, False), Literal(Q.prime, True))),
        frozenset((Literal(Q.integer, True), Literal(Q.rational, False))),
        frozenset((Literal(Q.integer_elements, True), Literal(Q.real_elements, False))),
        frozenset((Literal(Q.invertible, False), Literal(Q.positive_definite, True))),
        frozenset((Literal(Q.invertible, False), Literal(Q.singular, False))),
        frozenset((Literal(Q.invertible, False), Literal(Q.unitary, True))),
        frozenset((Literal(Q.invertible, True), Literal(Q.singular, True))),
        frozenset((Literal(Q.invertible, True), Literal(Q.square, False))),
        frozenset((Literal(Q.irrational, True), Literal(Q.rational, True))),
        frozenset((Literal(Q.irrational, True), Literal(Q.real, False))),
        frozenset((Literal(Q.lower_triangular, False), Literal(Q.triangular, True), Literal(Q.upper_triangular, False))),
        frozenset((Literal(Q.lower_triangular, True), Literal(Q.triangular, False))),
        frozenset((Literal(Q.negative, False), Literal(Q.nonpositive, True), Literal(Q.zero, False))),
        frozenset((Literal(Q.negative, False), Literal(Q.nonzero, True), Literal(Q.positive, False))),
        frozenset((Literal(Q.negative, False), Literal(Q.positive, False), Literal(Q.real, True), Literal(Q.zero, False))),
        frozenset((Literal(Q.negative, True), Literal(Q.nonpositive, False))),
        frozenset((Literal(Q.negative, True), Literal(Q.nonzero, False))),
        frozenset((Literal(Q.negative, True), Literal(Q.positive, True))),
        frozenset((Literal(Q.negative, True), Literal(Q.real, False))),
        frozenset((Literal(Q.negative, True), Literal(Q.zero, True))),
        frozenset((Literal(Q.nonnegative, False), Literal(Q.positive, True))),
        frozenset((Literal(Q.nonnegative, False), Literal(Q.zero, True))),
        frozenset((Literal(Q.nonnegative, True), Literal(Q.positive, False), Literal(Q.zero, False))),
        frozenset((Literal(Q.nonpositive, False), Literal(Q.zero, True))),
        frozenset((Literal(Q.nonzero, False), Literal(Q.positive, True))),
        frozenset((Literal(Q.normal, False), Literal(Q.unitary, True))),
        frozenset((Literal(Q.normal, True), Literal(Q.square, False))),
        frozenset((Literal(Q.orthogonal, False), Literal(Q.real, True), Literal(Q.unitary, True))),
        frozenset((Literal(Q.orthogonal, True), Literal(Q.positive_definite, False))),
        frozenset((Literal(Q.orthogonal, True), Literal(Q.unitary, False))),
        frozenset((Literal(Q.positive, False), Literal(Q.prime, True))),
        frozenset((Literal(Q.positive, True), Literal(Q.real, False))),
        frozenset((Literal(Q.positive, True), Literal(Q.zero, True))),
        frozenset((Literal(Q.rational, True), Literal(Q.real, False))),
        frozenset((Literal(Q.real, False), Literal(Q.zero, True))),
        frozenset((Literal(Q.square, False), Literal(Q.symmetric, True))),
        frozenset((Literal(Q.triangular, False), Literal(Q.unit_triangular, True))),
        frozenset((Literal(Q.triangular, False), Literal(Q.upper_triangular, True)))
    }

# -{ Known facts in Conjunctive Normal Form }-
@cacheit
def get_known_facts_cnf():
    return And(
        Q.invertible | Q.singular,
        Q.algebraic | ~Q.rational,
        Q.antihermitian | ~Q.imaginary,
        Q.complex_elements | ~Q.real_elements,
        Q.complex | ~Q.algebraic,
        Q.complex | ~Q.imaginary,
        Q.complex | ~Q.real,
        Q.complex | ~Q.transcendental,
        Q.even | ~Q.zero,
        Q.extended_real | ~Q.infinite,
        Q.extended_real | ~Q.real,
        Q.finite | ~Q.algebraic,
        Q.finite | ~Q.irrational,
        Q.finite | ~Q.rational,
        Q.finite | ~Q.transcendental,
        Q.fullrank | ~Q.invertible,
        Q.hermitian | ~Q.real,
        Q.integer | ~Q.even,
        Q.integer | ~Q.odd,
        Q.integer | ~Q.prime,
        Q.invertible | ~Q.positive_definite,
        Q.invertible | ~Q.unitary,
        Q.lower_triangular | ~Q.diagonal,
        Q.nonnegative | ~Q.positive,
        Q.nonnegative | ~Q.zero,
        Q.nonpositive | ~Q.negative,
        Q.nonpositive | ~Q.zero,
        Q.nonzero | ~Q.negative,
        Q.nonzero | ~Q.positive,
        Q.normal | ~Q.diagonal,
        Q.normal | ~Q.unitary,
        Q.positive_definite | ~Q.orthogonal,
        Q.positive | ~Q.prime,
        Q.rational | ~Q.integer,
        Q.real_elements | ~Q.integer_elements,
        Q.real | ~Q.irrational,
        Q.real | ~Q.negative,
        Q.real | ~Q.positive,
        Q.real | ~Q.rational,
        Q.real | ~Q.zero,
        Q.square | ~Q.invertible,
        Q.square | ~Q.normal,
        Q.square | ~Q.symmetric,
        Q.symmetric | ~Q.diagonal,
        Q.triangular | ~Q.lower_triangular,
        Q.triangular | ~Q.unit_triangular,
        Q.triangular | ~Q.upper_triangular,
        Q.unitary | ~Q.orthogonal,
        Q.upper_triangular | ~Q.diagonal,
        ~Q.algebraic | ~Q.transcendental,
        ~Q.antihermitian | ~Q.hermitian,
        ~Q.composite | ~Q.prime,
        ~Q.even | ~Q.odd,
        ~Q.finite | ~Q.infinite,
        ~Q.imaginary | ~Q.real,
        ~Q.invertible | ~Q.singular,
        ~Q.irrational | ~Q.rational,
        ~Q.negative | ~Q.positive,
        ~Q.negative | ~Q.zero,
        ~Q.positive | ~Q.zero,
        Q.even | Q.odd | ~Q.integer,
        Q.infinite | Q.real | ~Q.extended_real,
        Q.lower_triangular | Q.upper_triangular | ~Q.triangular,
        Q.negative | Q.positive | ~Q.nonzero,
        Q.negative | Q.zero | ~Q.nonpositive,
        Q.positive | Q.zero | ~Q.nonnegative,
        Q.diagonal | ~Q.lower_triangular | ~Q.upper_triangular,
        Q.invertible | ~Q.fullrank | ~Q.square,
        Q.orthogonal | ~Q.real | ~Q.unitary,
        Q.negative | Q.positive | Q.zero | ~Q.real,
        Q.algebraic | Q.transcendental | ~Q.complex | ~Q.finite,
        Q.irrational | Q.rational | ~Q.finite | ~Q.real
    )

# -{ Known facts in compressed sets }-
@cacheit
def get_known_facts_dict():
    return {
        Q.algebraic: set([Q.algebraic, Q.complex, Q.finite]),
        Q.antihermitian: set([Q.antihermitian]),
        Q.commutative: set([Q.commutative]),
        Q.complex: set([Q.complex]),
        Q.complex_elements: set([Q.complex_elements]),
        Q.composite: set([Q.composite]),
        Q.diagonal: set([Q.diagonal, Q.lower_triangular, Q.normal, Q.square,
        Q.symmetric, Q.triangular, Q.upper_triangular]),
        Q.eq: set([Q.eq]),
        Q.even: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.finite, Q.hermitian, Q.integer, Q.rational, Q.real]),
        Q.extended_real: set([Q.extended_real]),
        Q.finite: set([Q.finite]),
        Q.fullrank: set([Q.fullrank]),
        Q.ge: set([Q.ge]),
        Q.gt: set([Q.gt]),
        Q.hermitian: set([Q.hermitian]),
        Q.imaginary: set([Q.antihermitian, Q.complex, Q.imaginary]),
        Q.infinite: set([Q.extended_real, Q.infinite]),
        Q.integer: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.rational, Q.real]),
        Q.integer_elements: set([Q.complex_elements, Q.integer_elements,
        Q.real_elements]),
        Q.invertible: set([Q.fullrank, Q.invertible, Q.square]),
        Q.irrational: set([Q.complex, Q.extended_real, Q.finite, Q.hermitian,
        Q.irrational, Q.nonzero, Q.real]),
        Q.is_true: set([Q.is_true]),
        Q.le: set([Q.le]),
        Q.lower_triangular: set([Q.lower_triangular, Q.triangular]),
        Q.lt: set([Q.lt]),
        Q.ne: set([Q.ne]),
        Q.negative: set([Q.complex, Q.extended_real, Q.hermitian, Q.negative,
        Q.nonpositive, Q.nonzero, Q.real]),
        Q.nonnegative: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.real]),
        Q.nonpositive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonpositive, Q.real]),
        Q.nonzero: set([Q.complex, Q.extended_real, Q.hermitian, Q.nonzero,
        Q.real]),
        Q.normal: set([Q.normal, Q.square]),
        Q.odd: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.nonzero, Q.odd, Q.rational, Q.real]),
        Q.orthogonal: set([Q.fullrank, Q.invertible, Q.normal, Q.orthogonal,
        Q.positive_definite, Q.square, Q.unitary]),
        Q.positive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.nonzero, Q.positive, Q.real]),
        Q.positive_definite: set([Q.fullrank, Q.invertible,
        Q.positive_definite, Q.square]),
        Q.prime: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.nonnegative, Q.nonzero, Q.positive,
        Q.prime, Q.rational, Q.real]),
        Q.rational: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.rational, Q.real]),
        Q.real: set([Q.complex, Q.extended_real, Q.hermitian, Q.real]),
        Q.real_elements: set([Q.complex_elements, Q.real_elements]),
        Q.singular: set([Q.singular]),
        Q.square: set([Q.square]),
        Q.symmetric: set([Q.square, Q.symmetric]),
        Q.transcendental: set([Q.complex, Q.finite, Q.transcendental]),
        Q.triangular: set([Q.triangular]),
        Q.unit_triangular: set([Q.triangular, Q.unit_triangular]),
        Q.unitary: set([Q.fullrank, Q.invertible, Q.normal, Q.square,
        Q.unitary]),
        Q.upper_triangular: set([Q.triangular, Q.upper_triangular]),
        Q.zero: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.finite, Q.hermitian, Q.integer, Q.nonnegative,
        Q.nonpositive, Q.rational, Q.real, Q.zero]),
    }
