/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZookeeperReadAPI {
    private final CoreContainer coreContainer;

    public ZookeeperReadAPI(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @EndPoint(path={"/cluster/zk/data/*"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void readNode(SolrQueryRequest req, SolrQueryResponse rsp) {
        String path = req.getPathTemplateValues().get("*");
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        byte[] d = null;
        try {
            d = this.coreContainer.getZkController().getZkClient().getData(path, null, null, false);
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node: " + path);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected error", (Throwable)e);
        }
        if (d == null || d.length == 0) {
            rsp.add(path, null);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("wt", "raw");
        map.put("omitHeader", "true");
        req.setParams(SolrParams.wrapDefaults((SolrParams)new MapSolrParams(map), (SolrParams)req.getParams()));
        String mime = "application/octet-stream";
        if (d[0] == 123) {
            mime = "application/json";
        }
        if (d[0] == 60 || d[1] == 63) {
            mime = "application/xml; charset=UTF-8";
        }
        rsp.add("content", new ContentStreamBase.ByteArrayStream(d, null, mime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EndPoint(path={"/cluster/zk/ls/*"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.ZK_READ_PERM)
    public void listNodes(SolrQueryRequest req, SolrQueryResponse rsp) {
        String path = req.getPathTemplateValues().get("*");
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        try {
            Stat stat = this.coreContainer.getZkController().getZkClient().exists(path, null, true);
            rsp.add("stat", ew -> this.printStat(ew, stat));
            if (!req.getParams().getBool("c", true)) {
                return;
            }
            List l = this.coreContainer.getZkController().getZkClient().getChildren(path, null, false);
            String prefix = path.endsWith("/") ? path : path + "/";
            LinkedHashMap<String, Stat> stats = new LinkedHashMap<String, Stat>();
            for (String s : l) {
                try {
                    stats.put(s, this.coreContainer.getZkController().getZkClient().exists(prefix + s, null, false));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            rsp.add(path, ew -> {
                for (Map.Entry e : stats.entrySet()) {
                    ew.put((CharSequence)e.getKey(), ew1 -> this.printStat(ew1, (Stat)e.getValue()));
                }
            });
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node :" + path);
        }
        catch (Exception e) {
            rsp.add("content", new ContentStreamBase.StringStream(Utils.toJSONString(Collections.singletonMap("error", e.getMessage()))));
        }
        finally {
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        }
    }

    private void printStat(MapWriter.EntryWriter ew, Stat stat) throws IOException {
        ew.put((CharSequence)"version", stat.getVersion());
        ew.put((CharSequence)"aversion", stat.getAversion());
        ew.put((CharSequence)"children", stat.getNumChildren());
        ew.put((CharSequence)"ctime", stat.getCtime());
        ew.put((CharSequence)"cversion", stat.getCversion());
        ew.put((CharSequence)"czxid", stat.getCzxid());
        ew.put((CharSequence)"ephemeralOwner", stat.getEphemeralOwner());
        ew.put((CharSequence)"mtime", stat.getMtime());
        ew.put((CharSequence)"mzxid", stat.getMzxid());
        ew.put((CharSequence)"pzxid", stat.getPzxid());
        ew.put((CharSequence)"dataLength", stat.getDataLength());
    }
}

