/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2.algorithm;

import ext.plantuml.com.at.gadermaier.argon2.Util;
import ext.plantuml.com.at.gadermaier.argon2.algorithm.FillBlock;
import ext.plantuml.com.at.gadermaier.argon2.model.Argon2Type;
import ext.plantuml.com.at.gadermaier.argon2.model.Block;
import ext.plantuml.com.at.gadermaier.argon2.model.Instance;
import ext.plantuml.com.at.gadermaier.argon2.model.Position;

class FillSegment {
    FillSegment() {
    }

    static void fillSegment(Instance instance, Position position) {
        Block addressBlock = null;
        Block inputBlock = null;
        Block zeroBlock = null;
        boolean dataIndependentAddressing = FillSegment.isDataIndependentAddressing(instance, position);
        int startingIndex = FillSegment.getStartingIndex(position);
        int currentOffset = position.lane * instance.getLaneLength() + position.slice * instance.getSegmentLength() + startingIndex;
        int prevOffset = FillSegment.getPrevOffset(instance, currentOffset);
        if (dataIndependentAddressing) {
            addressBlock = new Block();
            zeroBlock = new Block();
            inputBlock = new Block();
            FillSegment.initAddressBlocks(instance, position, zeroBlock, inputBlock, addressBlock);
        }
        position.index = startingIndex;
        while (position.index < instance.getSegmentLength()) {
            long pseudoRandom;
            int refLane = FillSegment.getRefLane(instance, position, pseudoRandom = FillSegment.getPseudoRandom(instance, position, addressBlock, inputBlock, zeroBlock, prevOffset = FillSegment.rotatePrevOffset(instance, currentOffset, prevOffset), dataIndependentAddressing));
            int refColumn = FillSegment.getRefColumn(instance, position, pseudoRandom, refLane == position.lane);
            Block prevBlock = instance.memory[prevOffset];
            Block refBlock = instance.memory[instance.getLaneLength() * refLane + refColumn];
            Block currentBlock = instance.memory[currentOffset];
            boolean withXor = FillSegment.isWithXor(instance, position);
            FillBlock.fillBlock(prevBlock, refBlock, currentBlock, withXor);
            ++position.index;
            ++currentOffset;
            ++prevOffset;
        }
    }

    private static boolean isDataIndependentAddressing(Instance instance, Position position) {
        return instance.getType() == Argon2Type.Argon2i || instance.getType() == Argon2Type.Argon2id && position.pass == 0 && position.slice < 2;
    }

    private static void initAddressBlocks(Instance instance, Position position, Block zeroBlock, Block inputBlock, Block addressBlock) {
        inputBlock.v[0] = Util.intToLong(position.pass);
        inputBlock.v[1] = Util.intToLong(position.lane);
        inputBlock.v[2] = Util.intToLong(position.slice);
        inputBlock.v[3] = Util.intToLong(instance.memory.length);
        inputBlock.v[4] = Util.intToLong(instance.getIterations());
        inputBlock.v[5] = Util.intToLong(instance.getType().ordinal());
        if (position.pass == 0 && position.slice == 0) {
            FillSegment.nextAddresses(zeroBlock, inputBlock, addressBlock);
        }
    }

    private static boolean isWithXor(Instance instance, Position position) {
        return position.pass != 0 && instance.getVersion() != 16;
    }

    private static int getPrevOffset(Instance instance, int currentOffset) {
        if (currentOffset % instance.getLaneLength() == 0) {
            return currentOffset + instance.getLaneLength() - 1;
        }
        return currentOffset - 1;
    }

    private static int rotatePrevOffset(Instance instance, int currentOffset, int prevOffset) {
        if (currentOffset % instance.getLaneLength() == 1) {
            prevOffset = currentOffset - 1;
        }
        return prevOffset;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private static void nextAddresses(Block zeroBlock, Block inputBlock, Block addressBlock) {
        inputBlock.v[6] = inputBlock.v[6] + 1L;
        FillBlock.fillBlock(zeroBlock, inputBlock, addressBlock, false);
        FillBlock.fillBlock(zeroBlock, addressBlock, addressBlock, false);
    }

    private static long getPseudoRandom(Instance instance, Position position, Block addressBlock, Block inputBlock, Block zeroBlock, int prevOffset, boolean dataIndependentAddressing) {
        if (dataIndependentAddressing) {
            if (position.index % 128 == 0) {
                FillSegment.nextAddresses(zeroBlock, inputBlock, addressBlock);
            }
            return addressBlock.v[position.index % 128];
        }
        return instance.memory[prevOffset].v[0];
    }

    private static int getRefLane(Instance instance, Position position, long pseudoRandom) {
        int refLane = (int)((pseudoRandom >>> 32) % (long)instance.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            refLane = position.lane;
        }
        return refLane;
    }

    private static int getRefColumn(Instance instance, Position position, long pseudoRandom, boolean sameLane) {
        int referenceAreaSize;
        int startPosition;
        if (position.pass == 0) {
            startPosition = 0;
            referenceAreaSize = sameLane ? position.slice * instance.getSegmentLength() + position.index - 1 : position.slice * instance.getSegmentLength() + (position.index == 0 ? -1 : 0);
        } else {
            startPosition = (position.slice + 1) * instance.getSegmentLength() % instance.getLaneLength();
            referenceAreaSize = sameLane ? instance.getLaneLength() - instance.getSegmentLength() + position.index - 1 : instance.getLaneLength() - instance.getSegmentLength() + (position.index == 0 ? -1 : 0);
        }
        long relativePosition = pseudoRandom & 0xFFFFFFFFL;
        relativePosition = relativePosition * relativePosition >>> 32;
        relativePosition = (long)(referenceAreaSize - 1) - ((long)referenceAreaSize * relativePosition >>> 32);
        return (int)((long)startPosition + relativePosition) % instance.getLaneLength();
    }
}

