/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action.export.inferred;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.ReasonerStatus;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.protege.editor.owl.model.inference.VacuousAxiomVisitor;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.action.export.inferred.ExportCancelledException;
import org.protege.editor.owl.ui.action.export.inferred.ExportInferredOntologyPanel;
import org.protege.editor.owl.ui.action.export.inferred.ExportInferredOntologyWizard;
import org.protege.editor.owl.ui.action.export.inferred.MonitoredInferredAxiomGenerator;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.slf4j.LoggerFactory;

public class ExportInferredOntologyAction
extends ProtegeOWLAction {
    private static final long serialVersionUID = 5000834279491773432L;

    public void actionPerformed(ActionEvent e) {
        try {
            OWLReasonerManager reasonerManager = this.getOWLModelManager().getOWLReasonerManager();
            ReasonerStatus status = reasonerManager.getReasonerStatus();
            if (status != ReasonerStatus.INITIALIZED && status != ReasonerStatus.OUT_OF_SYNC) {
                ReasonerUtilities.warnUserIfReasonerIsNotConfigured((Component)((Object)this.getOWLWorkspace()), reasonerManager);
                return;
            }
            ExportInferredOntologyWizard wizard = new ExportInferredOntologyWizard(this.getOWLEditorKit());
            int ret = wizard.showModalDialog();
            if (ret != 0) {
                return;
            }
            new Thread((Runnable)new ExportTask(wizard), "Export Inferred Axioms").start();
        }
        catch (OWLOntologyCreationException e1) {
            JOptionPane.showMessageDialog((Component)this.getWorkspace(), "Could not create ontology:\n" + e1.getMessage(), "Error", 0);
        }
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }

    private class ExportTask
    implements Runnable {
        private ExportInferredOntologyWizard wizard;
        private ProgressMonitor monitor;
        private Set<InferenceType> precompute;
        private OWLOntologyManager outputManager;
        private List<InferredAxiomGenerator<? extends OWLAxiom>> inferredAxiomGenerators;
        private InferredOntologyGenerator inferredOntologyGenerator;
        private OWLOntology exportedOntology;
        private int taskCount;

        public ExportTask(ExportInferredOntologyWizard wizard) throws OWLOntologyCreationException {
            this.wizard = wizard;
            this.inferredAxiomGenerators = wizard.getInferredAxiomGenerators();
            this.outputManager = OWLManager.createOWLOntologyManager();
            this.inferredOntologyGenerator = new InferredOntologyGenerator(ExportInferredOntologyAction.this.getOWLModelManager().getReasoner(), this.inferredAxiomGenerators);
            this.exportedOntology = this.outputManager.createOntology(wizard.getOntologyID());
            this.taskCount = this.inferredAxiomGenerators.size() + 1;
            if (wizard.isIncludeAnnotations()) {
                ++this.taskCount;
            }
            if (wizard.isIncludeAssertedLogicalAxioms()) {
                ++this.taskCount;
            }
            this.taskCount += 3;
        }

        @Override
        public void run() {
            try {
                this.setupMonitor();
                this.adjustProgress("Initializing Reasoner", 0);
                this.precompute();
                this.inferredOntologyGenerator.fillOntology(this.outputManager.getOWLDataFactory(), this.exportedOntology);
                int currentTask = this.inferredAxiomGenerators.size();
                ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
                this.adjustProgress("Deleting trivial inferences", ++currentTask);
                this.deleteTrivialAxioms(changes);
                if (this.wizard.isIncludeAnnotations()) {
                    this.adjustProgress("Adding annotations", ++currentTask);
                    this.addAnnotations(changes);
                }
                if (this.wizard.isIncludeAssertedLogicalAxioms()) {
                    this.adjustProgress("Adding asserted axioms", ++currentTask);
                    this.addAsserted(changes);
                }
                this.adjustProgress("Applying extra changes", ++currentTask);
                this.outputManager.applyChanges(changes);
                this.adjustProgress("Saving...", ++currentTask);
                this.outputManager.saveOntology(this.exportedOntology, this.wizard.getFormat(), IRI.create((URI)this.wizard.getPhysicalURL()));
                this.monitor.close();
                JOptionPane.showMessageDialog((Component)ExportInferredOntologyAction.this.getWorkspace(), "The inferred axioms have been exported as an ontology to \n" + this.wizard.getPhysicalURL(), "Export finished", 1);
            }
            catch (ExportCancelledException cancelled) {
                JOptionPane.showMessageDialog((Component)ExportInferredOntologyAction.this.getWorkspace(), "The export operation has been cancelled at the users request", "Export aborted", 1);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(ExportInferredOntologyAction.class).warn("An error occurred whilst exporting the inferred ontology: {}", t);
            }
        }

        private void setupMonitor() {
            this.monitor = new ProgressMonitor((Component)((Object)ExportInferredOntologyAction.this.getOWLWorkspace()), "Exporting Inferred Ontology", "Initializing", 0, this.taskCount);
            this.precompute = EnumSet.noneOf(InferenceType.class);
            int task = 1;
            for (InferredAxiomGenerator<? extends OWLAxiom> generator : this.inferredAxiomGenerators) {
                ((MonitoredInferredAxiomGenerator)generator).setProgressMonitor(this.monitor, task++);
                this.precompute.addAll(ExportInferredOntologyPanel.getInferenceType(generator));
            }
        }

        private void adjustProgress(String taskDescription, int taskCount) {
            if (this.monitor.isCanceled()) {
                throw new ExportCancelledException();
            }
            this.monitor.setNote(taskDescription);
            this.monitor.setProgress(taskCount);
        }

        private void precompute() {
            EnumSet<InferenceType> precomputeNow = EnumSet.copyOf(this.precompute);
            OWLReasoner reasoner = ExportInferredOntologyAction.this.getOWLModelManager().getReasoner();
            if (!reasoner.getPendingChanges().isEmpty()) {
                reasoner.flush();
            }
            precomputeNow.retainAll(reasoner.getPrecomputableInferenceTypes());
            for (InferenceType inference : this.precompute) {
                if (!reasoner.isPrecomputed(inference)) continue;
                precomputeNow.remove(inference);
            }
            if (!precomputeNow.isEmpty()) {
                reasoner.precomputeInferences(precomputeNow.toArray(new InferenceType[precomputeNow.size()]));
            }
        }

        private void deleteTrivialAxioms(List<OWLOntologyChange> changes) {
            for (OWLAxiom axiom : this.exportedOntology.getAxioms()) {
                if (!VacuousAxiomVisitor.isVacuousAxiom(axiom) && !VacuousAxiomVisitor.involvesInverseSquared(axiom)) continue;
                changes.add((OWLOntologyChange)new RemoveAxiom(this.exportedOntology, axiom));
            }
        }

        private void addAnnotations(List<OWLOntologyChange> changes) {
            for (OWLOntology o : ExportInferredOntologyAction.this.getOWLModelManager().getReasoner().getRootOntology().getImportsClosure()) {
                for (OWLAnnotation annot : o.getAnnotations()) {
                    changes.add((OWLOntologyChange)new AddOntologyAnnotation(this.exportedOntology, annot));
                }
                for (OWLAnnotationAssertionAxiom axiom : o.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                    changes.add((OWLOntologyChange)new AddAxiom(this.exportedOntology, (OWLAxiom)axiom));
                }
            }
        }

        private void addAsserted(List<OWLOntologyChange> changes) {
            for (OWLOntology o : ExportInferredOntologyAction.this.getOWLModelManager().getReasoner().getRootOntology().getImportsClosure()) {
                for (OWLLogicalAxiom ax : o.getLogicalAxioms()) {
                    if (ax.isAnnotated() && this.exportedOntology.containsAxiom(ax.getAxiomWithoutAnnotations())) {
                        changes.add((OWLOntologyChange)new RemoveAxiom(this.exportedOntology, ax.getAxiomWithoutAnnotations()));
                    }
                    changes.add((OWLOntologyChange)new AddAxiom(this.exportedOntology, (OWLAxiom)ax));
                }
            }
        }
    }
}

