/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.semanticweb.owlapi.model.IRI;

public class ImportConfirmationPage
extends AbstractOWLWizardPanel {
    private static final long serialVersionUID = -8146050890918692126L;
    public static final String ID = "ImportConfirmationPage";
    private JComponent importedOntologiesComponent;
    private TitledBorder titledBorder;
    private Object backPanelDescriptor;

    public ImportConfirmationPage(OWLEditorKit owlEditorKit) {
        super(ID, "Confirm imports", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("The system will import the following ontologies.  Press Finish to import these ontologies, or Cancel to exit the wizard without importing any ontologies.");
        this.importedOntologiesComponent = new JPanel(new BorderLayout());
        parent.setLayout(new BorderLayout());
        parent.add((Component)this.importedOntologiesComponent, "North");
    }

    public void displayingPanel() {
        super.displayingPanel();
        this.fillImportList();
    }

    private void fillImportList() {
        this.importedOntologiesComponent.removeAll();
        Box box = new Box(1);
        boolean advanced = ((OntologyImportWizard)this.getWizard()).isCustomizeImports();
        Set<ImportInfo> parameters = ((OntologyImportWizard)this.getWizard()).getImports();
        for (ImportInfo parameter : parameters) {
            if (!parameter.isReady()) continue;
            if (advanced) {
                ImportEntryPanel importPanel = new ImportEntryPanel(parameter);
                box.add(importPanel);
                continue;
            }
            box.add(new JLabel(parameter.getPhysicalLocation().toString()));
        }
        this.importedOntologiesComponent.add((Component)box, "North");
    }

    public void setBackPanelDescriptor(Object backPanelDescriptor) {
        this.backPanelDescriptor = backPanelDescriptor;
    }

    public Object getBackPanelDescriptor() {
        if (((OntologyImportWizard)this.getWizard()).isCustomizeImports()) {
            return "SelectImportLocationPage";
        }
        return this.backPanelDescriptor;
    }

    public Object getNextPanelDescriptor() {
        return WizardPanel.FINISH;
    }

    private class ImportEntryPanel
    extends JPanel {
        private static final long serialVersionUID = -4945897856195350142L;

        public ImportEntryPanel(ImportInfo parameter) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 4, 0));
            this.setLayout(new BorderLayout(1, 1));
            JPanel center = new JPanel();
            center.setLayout(new BoxLayout(center, 1));
            JLabel physicalLocationLabel = new JLabel("Load import from " + parameter.getPhysicalLocation().toString());
            physicalLocationLabel.setFont(physicalLocationLabel.getFont().deriveFont(10.0f));
            physicalLocationLabel.setAlignmentX(0.0f);
            center.add(physicalLocationLabel);
            if (!parameter.getOntologyID().isAnonymous()) {
                JLabel ontologyNameLabel = new JLabel("Imported Ontology Name " + ((IRI)parameter.getOntologyID().getOntologyIRI().get()).toString());
                ontologyNameLabel.setAlignmentX(0.0f);
                center.add(ontologyNameLabel);
                if (parameter.getOntologyID().getVersionIRI().isPresent()) {
                    JLabel ontologyVersionLabel = new JLabel("Imported Ontology Version " + parameter.getOntologyID().getVersionIRI());
                    ontologyVersionLabel.setAlignmentX(0.0f);
                    center.add(ontologyVersionLabel);
                }
            } else {
                JLabel anonymousLabel = new JLabel("Imported Ontology is anonymous.");
                anonymousLabel.setAlignmentX(0.0f);
                center.add(anonymousLabel);
            }
            center.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            Border lineBorder = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            ImportConfirmationPage.this.titledBorder = BorderFactory.createTitledBorder(lineBorder, "Import Declaration: " + parameter.getImportLocation().toString());
            this.setBorder(ImportConfirmationPage.this.titledBorder);
            this.add((Component)center, "Center");
        }
    }
}

