/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilder;

class InstanceBuilderRegistry {
    private final List<RegisteredBuilder> builders = new ArrayList<RegisteredBuilder>();

    public void register(String mask, InstanceBuilder<?> builder) {
        this.builders.add(new RegisteredBuilder(mask, builder));
    }

    public void register(Class<?> type, boolean subtypes, InstanceBuilder<?> builder) {
        this.register(FieldAccessor.getClassMask(type, subtypes), builder);
    }

    public <T> InstanceBuilder<? extends T> getBuilder(Instance instance, Class<T> type) {
        for (RegisteredBuilder builder : this.builders) {
            if (!FieldAccessor.matchClassMask(instance, builder.mask) || !type.isAssignableFrom(builder.builder.getType())) continue;
            return builder.builder;
        }
        return null;
    }

    public String[] getMasks(Class<?> ... types) {
        HashSet<String> masks = new HashSet<String>();
        for (RegisteredBuilder builder : this.builders) {
            for (Class clazz : types) {
                if (!clazz.isAssignableFrom(builder.builder.getType())) continue;
                masks.add(builder.mask);
            }
        }
        return masks.toArray(new String[0]);
    }

    private static class RegisteredBuilder {
        private final String mask;
        private final InstanceBuilder<?> builder;

        public RegisteredBuilder(String mask, InstanceBuilder<?> builder) {
            this.mask = mask;
            this.builder = builder;
        }
    }
}

