export { tencentSign, tencentSignV1 } from './utils';
export interface CapiOptions {
    isV3?: boolean;
    debug?: boolean;
    host?: string;
    baseHost?: string;
    path?: string;
    method?: string;
    protocol?: string;
    timeout?: number;
    ServiceType: string;
    Version?: string;
    Region: string;
    SecretId: string;
    SecretKey: string;
    Token?: string;
    SignatureMethod?: string;
    RequestClient?: string;
}
export interface RequestData {
    Action: string;
    RequestClient?: string;
    Version?: string;
    [propName: string]: any;
}
export interface RequestOptions {
    isV3?: boolean;
    debug?: boolean;
    host?: string;
    baseHost?: string;
    path?: string;
    method?: string;
    protocol?: string;
    timeout?: number;
    RequestClient?: string;
}
export interface CapiInstance {
    request: (data: RequestData, opts?: RequestOptions, isV3?: boolean) => Promise<any>;
}
export declare class Capi implements CapiInstance {
    options: CapiOptions;
    defaultOptions: CapiOptions;
    constructor(options: CapiOptions);
    request(data: RequestData, opts?: RequestOptions, isV3?: boolean): any;
}
//# sourceMappingURL=index.d.ts.map