/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;

public class PStmtKey {
    private final String sql;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private final String catalog;
    private final String schema;
    private final Integer autoGeneratedKeys;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private final PoolingConnection.StatementType statementType;
    private transient StatementBuilder builder;

    @Deprecated
    public PStmtKey(String string) {
        this(string, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, int n, int n2) {
        this(string, null, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2) {
        this(string, string2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n) {
        this(string, string2, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)n);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, int n3) {
        this(string, string2, n, n2, n3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, int n3, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    @Deprecated
    public PStmtKey(String string, String string2, int[] nArray) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = nArray == null ? null : Arrays.copyOf(nArray, nArray.length);
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    @Deprecated
    public PStmtKey(String string, String string2, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    @Deprecated
    public PStmtKey(String string, String string2, PoolingConnection.StatementType statementType, Integer n) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = n;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String string, String string2, String string3) {
        this(string, string2, string3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n) {
        this(string, string2, string3, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)n);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2) {
        this(string, string2, string3, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, int n3) {
        this(string, string2, string3, n, n2, n3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, int n3, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    public PStmtKey(String string, String string2, String string3, int[] nArray) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = nArray == null ? null : Arrays.copyOf(nArray, nArray.length);
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    public PStmtKey(String string, String string2, String string3, PoolingConnection.StatementType statementType) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String string, String string2, String string3, PoolingConnection.StatementType statementType, Integer n) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.statementType = statementType;
        this.autoGeneratedKeys = n;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String string, String string2, String string3, String[] stringArray) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    @Deprecated
    public PStmtKey(String string, String string2, String[] stringArray) {
        this.sql = string;
        this.catalog = string2;
        this.schema = null;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        if (this.builder == null) {
            throw new IllegalStateException("Prepared statement key is invalid.");
        }
        return this.builder.createStatement(connection);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (!Objects.equals(this.autoGeneratedKeys, pStmtKey.autoGeneratedKeys)) {
            return false;
        }
        if (!Objects.equals(this.catalog, pStmtKey.catalog)) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, pStmtKey.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, pStmtKey.columnNames)) {
            return false;
        }
        if (!Objects.equals(this.resultSetConcurrency, pStmtKey.resultSetConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.resultSetHoldability, pStmtKey.resultSetHoldability)) {
            return false;
        }
        if (!Objects.equals(this.resultSetType, pStmtKey.resultSetType)) {
            return false;
        }
        if (!Objects.equals(this.schema, pStmtKey.schema)) {
            return false;
        }
        if (!Objects.equals(this.sql, pStmtKey.sql)) {
            return false;
        }
        return this.statementType == pStmtKey.statementType;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSql() {
        return this.sql;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this.statementType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoGeneratedKeys, this.catalog, Arrays.hashCode(this.columnIndexes), Arrays.hashCode(this.columnNames), this.resultSetConcurrency, this.resultSetHoldability, this.resultSetType, this.schema, this.sql, this.statementType});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PStmtKey: sql=");
        stringBuilder.append(this.sql);
        stringBuilder.append(", catalog=");
        stringBuilder.append(this.catalog);
        stringBuilder.append(", schema=");
        stringBuilder.append(this.schema);
        stringBuilder.append(", resultSetType=");
        stringBuilder.append(this.resultSetType);
        stringBuilder.append(", resultSetConcurrency=");
        stringBuilder.append(this.resultSetConcurrency);
        stringBuilder.append(", resultSetHoldability=");
        stringBuilder.append(this.resultSetHoldability);
        stringBuilder.append(", autoGeneratedKeys=");
        stringBuilder.append(this.autoGeneratedKeys);
        stringBuilder.append(", columnIndexes=");
        stringBuilder.append(Arrays.toString(this.columnIndexes));
        stringBuilder.append(", columnNames=");
        stringBuilder.append(Arrays.toString(this.columnNames));
        stringBuilder.append(", statementType=");
        stringBuilder.append((Object)this.statementType);
        return stringBuilder.toString();
    }

    private static interface StatementBuilder {
        public Statement createStatement(Connection var1) throws SQLException;
    }

    private class PreparedStatementWithResultSetHoldability
    implements StatementBuilder {
        private PreparedStatementWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
        }
    }

    private class PreparedStatementWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedStatementWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
        }
    }

    private class PreparedStatementWithColumnNames
    implements StatementBuilder {
        private PreparedStatementWithColumnNames() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnNames);
        }
    }

    private class PreparedStatementWithColumnIndexes
    implements StatementBuilder {
        private PreparedStatementWithColumnIndexes() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnIndexes);
        }
    }

    private class PreparedStatementWithAutoGeneratedKeys
    implements StatementBuilder {
        private PreparedStatementWithAutoGeneratedKeys() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.autoGeneratedKeys);
        }
    }

    private class PreparedStatementSQL
    implements StatementBuilder {
        private PreparedStatementSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql);
        }
    }

    private class PreparedCallWithResultSetHoldability
    implements StatementBuilder {
        private PreparedCallWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
        }
    }

    private class PreparedCallWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedCallWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
        }
    }

    private class PreparedCallSQL
    implements StatementBuilder {
        private PreparedCallSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql);
        }
    }
}

