/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.options;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.graalvm.visualvm.modules.appui.options.NetworkOptionsPanel;
import org.graalvm.visualvm.modules.appui.options.ProxySettings;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class NetworkOptionsModel {
    private static final Logger LOGGER = Logger.getLogger(NetworkOptionsModel.class.getName());
    private static final String NON_PROXY_HOSTS_DELIMITER = "|";
    private static final RequestProcessor rp = new RequestProcessor(NetworkOptionsModel.class);

    NetworkOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return ProxySettings.getPreferences();
    }

    boolean getUsageStatistics() {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null) {
            return NetworkOptionsModel.getProxyPreferences().getBoolean(key, Boolean.FALSE);
        }
        return false;
    }

    void setUsageStatistics(boolean use) {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null && use != this.getUsageStatistics()) {
            NetworkOptionsModel.getProxyPreferences().putBoolean(key, use);
        }
    }

    int getProxyType() {
        return NetworkOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int proxyType) {
        if (proxyType != this.getProxyType()) {
            if (1 == proxyType) {
                NetworkOptionsModel.getProxyPreferences().putInt("proxyType", NetworkOptionsModel.usePAC() ? 3 : 1);
            } else {
                NetworkOptionsModel.getProxyPreferences().putInt("proxyType", proxyType);
            }
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpProxyHost())) {
            NetworkOptionsModel.getProxyPreferences().put("proxyHttpHost", proxyHost);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpProxyPort())) {
            NetworkOptionsModel.getProxyPreferences().put("proxyHttpPort", NetworkOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpsProxyHost())) {
            NetworkOptionsModel.getProxyPreferences().put("proxyHttpsHost", proxyHost);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpsProxyPort())) {
            NetworkOptionsModel.getProxyPreferences().put("proxyHttpsPort", NetworkOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String socksHost) {
        if (!socksHost.equals(this.getSocksHost())) {
            NetworkOptionsModel.getProxyPreferences().put("proxySocksHost", socksHost);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String socksPort) {
        if (!socksPort.equals(this.getSocksPort())) {
            NetworkOptionsModel.getProxyPreferences().put("proxySocksPort", NetworkOptionsModel.validatePort(socksPort) ? socksPort : "");
        }
    }

    String getOriginalHttpsHost() {
        return NetworkOptionsModel.getProxyPreferences().get("proxyHttpsHost", "");
    }

    String getOriginalHttpsPort() {
        return NetworkOptionsModel.getProxyPreferences().get("proxyHttpsPort", "");
    }

    String getOriginalSocksHost() {
        return NetworkOptionsModel.getProxyPreferences().get("proxySocksHost", "");
    }

    String getOriginalSocksPort() {
        return NetworkOptionsModel.getProxyPreferences().get("proxySocksPort", "");
    }

    String getNonProxyHosts() {
        return NetworkOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String nonProxy) {
        if (!nonProxy.equals(this.getNonProxyHosts())) {
            NetworkOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", NetworkOptionsModel.view2code(nonProxy));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean use) {
        if (use != this.useProxyAuthentication()) {
            NetworkOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", use);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean use) {
        if (use != this.useProxyAllProtocols()) {
            NetworkOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", use);
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String username) {
        NetworkOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", username);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] password) {
        ProxySettings.setAuthenticationPassword(password);
    }

    static boolean usePAC() {
        String pacUrl = NetworkOptionsModel.getProxyPreferences().get("systemPAC", "");
        return pacUrl != null && pacUrl.length() > 0;
    }

    static void testConnection(final NetworkOptionsPanel panel, final int proxyType, final String proxyHost, final String proxyPortString, final String nonProxyHosts) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                NetworkOptionsModel.testProxy(panel, proxyType, proxyHost, proxyPortString, nonProxyHosts);
            }
        });
    }

    private static void testProxy(NetworkOptionsPanel panel, int proxyType, String proxyHost, String proxyPortString, String nonProxyHosts) {
        Proxy testingProxy;
        String testingUrlHost;
        URL testingUrl;
        panel.updateTestConnectionStatus(TestingStatus.WAITING, null);
        TestingStatus status = TestingStatus.FAILED;
        String message = null;
        try {
            testingUrl = new URL("http://netbeans.org");
            testingUrlHost = testingUrl.getHost();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.SEVERE, "Cannot create url from string.", ex);
            panel.updateTestConnectionStatus(status, message);
            return;
        }
        switch (proxyType) {
            case 0: {
                testingProxy = Proxy.NO_PROXY;
                break;
            }
            case 1: 
            case 3: {
                nonProxyHosts = ProxySettings.getSystemNonProxyHosts();
                if (NetworkOptionsModel.isNonProxy(testingUrlHost, nonProxyHosts)) {
                    testingProxy = Proxy.NO_PROXY;
                    break;
                }
                String host = ProxySettings.getTestSystemHttpHost();
                int port = 0;
                try {
                    port = Integer.parseInt(ProxySettings.getTestSystemHttpPort());
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.INFO, "Cannot parse port number", ex);
                }
                testingProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
                break;
            }
            case 2: {
                nonProxyHosts = NetworkOptionsModel.view2code(nonProxyHosts);
                if (NetworkOptionsModel.isNonProxy(testingUrl.getHost(), nonProxyHosts)) {
                    testingProxy = Proxy.NO_PROXY;
                    break;
                }
                try {
                    int proxyPort = Integer.parseInt(proxyPortString);
                    testingProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                    break;
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.INFO, "Cannot parse port number", ex);
                    status = TestingStatus.FAILED;
                    message = NbBundle.getMessage(NetworkOptionsModel.class, (String)"NetworkOptionsModel_PortError");
                    panel.updateTestConnectionStatus(status, message);
                    return;
                }
            }
            default: {
                testingProxy = Proxy.NO_PROXY;
            }
        }
        try {
            status = NetworkOptionsModel.testHttpConnection(testingUrl, testingProxy) ? TestingStatus.OK : TestingStatus.FAILED;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot connect via http protocol.", ex);
            message = ex.getLocalizedMessage();
        }
        panel.updateTestConnectionStatus(status, message);
    }

    private static boolean testHttpConnection(URL url, Proxy proxy) throws IOException {
        boolean result = false;
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection(proxy);
        httpConnection.setConnectTimeout(5000);
        httpConnection.connect();
        if (httpConnection.getResponseCode() == 200 || httpConnection.getResponseCode() == 302) {
            result = true;
        }
        httpConnection.disconnect();
        return result;
    }

    private static boolean isNonProxy(String host, String nonProxyHosts) {
        boolean isNonProxy = false;
        if (host != null && nonProxyHosts != null) {
            StringTokenizer st = new StringTokenizer(nonProxyHosts, NON_PROXY_HOSTS_DELIMITER, false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(host)) continue;
                isNonProxy = true;
                break;
            }
        }
        return isNonProxy;
    }

    private static boolean validatePort(String port) {
        boolean ok;
        block3: {
            if (port.trim().length() == 0) {
                return true;
            }
            ok = false;
            try {
                Integer.parseInt(port);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nfe);
            }
        }
        return ok;
    }

    private static String code2view(String code) {
        return code == null ? code : code.replace(NON_PROXY_HOSTS_DELIMITER, ", ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", NON_PROXY_HOSTS_DELIMITER);
    }

    static enum TestingStatus {
        OK,
        FAILED,
        WAITING,
        NOT_TESTED;

    }
}

