/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassLoaderTable;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.classfile.PlaceholderClassInfo;

public class SameNameClassGroup {
    private List classes = new ArrayList(4);

    public List getAll() {
        return this.classes;
    }

    public void add(BaseClassInfo clazz) {
        this.classes.add(clazz);
    }

    public static BaseClassInfo checkForCompatibility(BaseClassInfo clazz, int classLoaderId) {
        int entryLoader = clazz.getLoaderId();
        if (entryLoader == classLoaderId) {
            return clazz;
        }
        if (SameNameClassGroup.isParentLoaderTo(entryLoader, classLoaderId)) {
            return clazz;
        }
        if (clazz instanceof PlaceholderClassInfo && SameNameClassGroup.isParentLoaderTo(classLoaderId, entryLoader)) {
            clazz.setLoaderId(classLoaderId);
            return clazz;
        }
        if (classLoaderId > 0) {
            int loader = ClassRepository.getDefiningClassLoaderId(clazz.getName(), classLoaderId);
            if (loader == -1) {
                return null;
            }
            if (loader == entryLoader) {
                return clazz;
            }
        }
        return null;
    }

    public BaseClassInfo findCompatibleClass(int classLoaderId) {
        BaseClassInfo clazz;
        int i;
        int size = this.classes.size();
        for (i = 0; i < size; ++i) {
            clazz = (BaseClassInfo)this.classes.get(i);
            if (clazz.getLoaderId() != classLoaderId) continue;
            return clazz;
        }
        for (i = 0; i < size; ++i) {
            clazz = (BaseClassInfo)this.classes.get(i);
            if ((clazz = SameNameClassGroup.checkForCompatibility(clazz, classLoaderId)) == null) continue;
            return clazz;
        }
        return null;
    }

    public void replace(BaseClassInfo clazz1, BaseClassInfo clazz2) {
        this.classes.remove(clazz1);
        this.classes.add(clazz2);
    }

    private static boolean isParentLoaderTo(int testParentLoader, int testChildLoader) {
        int parent = ClassLoaderTable.getParentLoader(testChildLoader);
        while (parent != testParentLoader) {
            if (parent == 0) {
                return false;
            }
            parent = ClassLoaderTable.getParentLoader(parent);
        }
        return true;
    }
}

