/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.columns.ui.ColumnValuesFrequencyUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.gephi.utils.HTMLEscape;
import org.gephi.utils.TempDirUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ColumnValuesFrequency
implements AttributeColumnsManipulator {
    public static final int MAX_PIE_CHART_CATEGORIES = 100;

    public void execute(Table table, Column column) {
    }

    public String getName() {
        return NbBundle.getMessage(ColumnValuesFrequency.class, (String)"ColumnValuesFrequency.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(ColumnValuesFrequency.class, (String)"ColumnValuesFrequency.description");
    }

    public boolean canManipulateColumn(Table table, Column column) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        return ac.getTableRowsCount(table) > 0;
    }

    public AttributeColumnsManipulatorUI getUI(Table table, Column column) {
        return new ColumnValuesFrequencyUI();
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 0;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/gephi/datalab/plugin/manipulators/resources/frequency-list.png");
    }

    public String getReportHTML(Table table, Column column, Map<Object, Integer> valuesFrequencies, JFreeChart pieChart, Dimension dimension) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        int totalValuesCount = ac.getTableRowsCount(table);
        ArrayList<Object> values = new ArrayList<Object>(valuesFrequencies.keySet());
        if (!values.isEmpty() && values.get(0) instanceof Comparable) {
            Collections.sort(values, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        if (o1 == null) {
                            return 0;
                        }
                        return 1;
                    }
                    return ((Comparable)o1).compareTo(o2);
                }
            });
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(NbBundle.getMessage(ColumnValuesFrequency.class, (String)"ColumnValuesFrequency.report.header", (Object)HTMLEscape.stringToHTMLString((String)column.getTitle())));
        sb.append("<hr>");
        sb.append("<ol>");
        for (Object value : values) {
            this.writeValue(sb, value, valuesFrequencies, totalValuesCount);
        }
        sb.append("</ol>");
        sb.append("<hr>");
        if (!values.isEmpty() && values.size() <= 100) {
            try {
                if (pieChart != null) {
                    this.writePieChart(sb, pieChart, dimension);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            sb.append(NbBundle.getMessage(ColumnValuesFrequency.class, (String)"ColumnValuesFrequency.report.piechart.not-shown"));
        }
        sb.append("</html>");
        return sb.toString();
    }

    private void writeValue(StringBuilder sb, Object value, Map<Object, Integer> valuesFrequencies, float totalValuesCount) {
        int frequency = valuesFrequencies.get(value);
        sb.append("<li>");
        sb.append("<b>");
        if (value != null) {
            sb.append(HTMLEscape.stringToHTMLString((String)AttributeUtils.print((Object)value)));
        } else {
            sb.append("null");
        }
        sb.append("</b> - ");
        sb.append(frequency);
        sb.append(" (");
        sb.append((float)frequency / totalValuesCount * 100.0f);
        sb.append("%");
        sb.append(" )");
        sb.append("</li>");
    }

    public Map<Object, Integer> buildValuesFrequencies(Table table, Column column) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        return ac.calculateColumnValuesFrequencies(table, column);
    }

    public JFreeChart buildPieChart(Map<Object, Integer> valuesFrequencies) {
        ArrayList<Object> values = new ArrayList<Object>(valuesFrequencies.keySet());
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        for (Object value : values) {
            pieDataset.setValue((Comparable)((Object)(value != null ? "'" + AttributeUtils.print((Object)value) + "'" : "null")), (Number)valuesFrequencies.get(value));
        }
        JFreeChart chart = ChartFactory.createPieChart((String)NbBundle.getMessage(ColumnValuesFrequency.class, (String)"ColumnValuesFrequency.report.piechart.title"), (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        return chart;
    }

    private void writePieChart(StringBuilder sb, JFreeChart chart, Dimension dimension) throws IOException {
        TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
        String fileName = "frequencies-pie-chart.png";
        File file = tempDir.createFile(fileName);
        String imageFile = "<center><img src=\"file:" + file.getAbsolutePath() + "\"</img></center>";
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)(dimension != null ? dimension.width : 1000), (int)(dimension != null ? dimension.height : 1000));
        sb.append(imageFile);
    }
}

