/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;

public class SaveConfig
extends GenericFunction {
    public SaveConfig(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.saveconfig";
    }

    @Override
    public void begin() {
        File file = Config.getConfigFile();
        if (file == null) {
            file = Config.HOME_CONFIG_FILE;
        }
        JFileChooser jFileChooser = new JFileChooser(file.getAbsoluteFile().getParent());
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this._parentFrame);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.saveConfig(file2);
        }
    }

    public void silentSave() {
        this.saveConfig(Config.getConfigFile());
    }

    public void autosaveSwitched(boolean bl) {
        File file = Config.getConfigFile();
        if (bl && file == null) {
            this.begin();
        } else if (!bl && file != null) {
            this.silentSave();
        }
    }

    private void saveConfig(File file) {
        block15: {
            Rectangle rectangle = this._app.getFrame().getBounds();
            String string = rectangle.x + "x" + rectangle.y + "x" + rectangle.width + "x" + rectangle.height;
            Config.setConfigString("prune.windowbounds", string);
            String string2 = this.createLatLonStringForConfig();
            if (string2 != null) {
                Config.setConfigString("prune.latlonrange", string2);
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                Config.getAllConfig().store(fileOutputStream, "GpsPrune config file");
            }
            catch (IOException iOException) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block15;
            }
            catch (NullPointerException nullPointerException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block15;
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        Config.setConfigFile(file);
    }

    private String createLatLonStringForConfig() {
        Track track = this._app.getTrackInfo().getTrack();
        if (track.getNumPoints() >= 2) {
            DoubleRange doubleRange = track.getLatRange();
            DoubleRange doubleRange2 = track.getLonRange();
            if (doubleRange.getRange() > 0.0 && doubleRange2.getRange() > 0.0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Double.toString(doubleRange.getMinimum()));
                stringBuffer.append(';');
                stringBuffer.append(Double.toString(doubleRange.getMaximum()));
                stringBuffer.append(';');
                stringBuffer.append(Double.toString(doubleRange2.getMinimum()));
                stringBuffer.append(';');
                stringBuffer.append(Double.toString(doubleRange2.getMaximum()));
                return stringBuffer.toString();
            }
        }
        return null;
    }
}

