/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ApplicationContextBuilder {
    @Nonnull
    public ApplicationContextBuilder singletons(Object ... var1);

    @Nonnull
    public ApplicationContextBuilder deduceEnvironment(@Nullable Boolean var1);

    @Nonnull
    public ApplicationContextBuilder environments(String ... var1);

    @Nonnull
    public ApplicationContextBuilder packages(String ... var1);

    @Nonnull
    public ApplicationContextBuilder properties(@Nullable Map<String, Object> var1);

    @Nonnull
    public ApplicationContextBuilder propertySources(PropertySource ... var1);

    @Nonnull
    public ApplicationContextBuilder environmentPropertySource(boolean var1);

    @Nonnull
    public ApplicationContextBuilder environmentVariableIncludes(String ... var1);

    @Nonnull
    public ApplicationContextBuilder environmentVariableExcludes(String ... var1);

    @Nonnull
    public ApplicationContextBuilder mainClass(@Nullable Class var1);

    @Nonnull
    public ApplicationContextBuilder classLoader(@Nullable ClassLoader var1);

    @Nonnull
    public ApplicationContext build();

    @Nonnull
    public ApplicationContextBuilder include(String ... var1);

    @Nonnull
    public ApplicationContextBuilder exclude(String ... var1);

    @Nonnull
    default public ApplicationContextBuilder args(String ... args) {
        return this;
    }

    @Nonnull
    default public ApplicationContext start() {
        return this.build().start();
    }

    @Nonnull
    default public <T extends AutoCloseable> T run(@Nonnull Class<T> type) {
        LifeCycle lifeCycle;
        ArgumentUtils.requireNonNull((String)"type", type);
        ApplicationContext applicationContext = this.start();
        AutoCloseable bean = (AutoCloseable)applicationContext.getBean(type);
        if (bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }
}

