/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.commons.AnnotationRemapper;
import org.jruby.org.objectweb.asm.commons.Remapper;

public class MethodRemapper
extends MethodVisitor {
    protected final Remapper remapper;

    public MethodRemapper(MethodVisitor methodVisitor, Remapper remapper) {
        this(589824, methodVisitor, remapper);
    }

    protected MethodRemapper(int api, MethodVisitor methodVisitor, Remapper remapper) {
        super(api, methodVisitor);
        this.remapper = remapper;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(parameter, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitFrame(int type2, int numLocal, Object[] local2, int numStack, Object[] stack) {
        super.visitFrame(type2, numLocal, this.remapFrameTypes(numLocal, local2), numStack, this.remapFrameTypes(numStack, stack));
    }

    private Object[] remapFrameTypes(int numTypes, Object[] frameTypes) {
        if (frameTypes == null) {
            return frameTypes;
        }
        Object[] remappedFrameTypes = null;
        for (int i2 = 0; i2 < numTypes; ++i2) {
            if (!(frameTypes[i2] instanceof String)) continue;
            if (remappedFrameTypes == null) {
                remappedFrameTypes = new Object[numTypes];
                System.arraycopy(frameTypes, 0, remappedFrameTypes, 0, numTypes);
            }
            remappedFrameTypes[i2] = this.remapper.mapType((String)frameTypes[i2]);
        }
        return remappedFrameTypes == null ? frameTypes : remappedFrameTypes;
    }

    public void visitFieldInsn(int opcode, String owner2, String name2, String descriptor) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner2), this.remapper.mapFieldName(owner2, name2, descriptor), this.remapper.mapDesc(descriptor));
    }

    public void visitMethodInsn(int opcodeAndSource, String owner2, String name2, String descriptor, boolean isInterface) {
        if (this.api < 327680 && (opcodeAndSource & 0x100) == 0) {
            super.visitMethodInsn(opcodeAndSource, owner2, name2, descriptor, isInterface);
            return;
        }
        super.visitMethodInsn(opcodeAndSource, this.remapper.mapType(owner2), this.remapper.mapMethodName(owner2, name2, descriptor), this.remapper.mapMethodDesc(descriptor), isInterface);
    }

    public void visitInvokeDynamicInsn(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
        for (int i2 = 0; i2 < bootstrapMethodArguments.length; ++i2) {
            remappedBootstrapMethodArguments[i2] = this.remapper.mapValue(bootstrapMethodArguments[i2]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(name2, descriptor), this.remapper.mapMethodDesc(descriptor), (Handle)this.remapper.mapValue(bootstrapMethodHandle), remappedBootstrapMethodArguments);
    }

    public void visitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type2));
    }

    public void visitLdcInsn(Object value2) {
        super.visitLdcInsn(this.remapper.mapValue(value2));
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(descriptor), numDimensions);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitTryCatchBlock(Label start2, Label end2, Label handler, String type2) {
        super.visitTryCatchBlock(start2, end2, handler, type2 == null ? null : this.remapper.mapType(type2));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitLocalVariable(String name2, String descriptor, String signature, Label start2, Label end2, int index2) {
        super.visitLocalVariable(name2, this.remapper.mapDesc(descriptor), this.remapper.mapSignature(signature, true), start2, end2, index2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end2, int[] index2, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index2, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? annotationVisitor : this.createAnnotationRemapper(annotationVisitor);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }
}

