/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\f\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"COMPILER_JARS", "", "", "FILE_PROTOCOL", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "findCompilerJar", "Ljava/io/File;", "classFromJarInTheSameLocation", "Ljava/lang/Class;", "kotlinHome", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "aClass", "matchMaybeVersionedFile", "", "baseName", "toFileOrNull", "kotlin-runner"})
public final class FindCompilerKt {
    @NotNull
    private static final List<String> COMPILER_JARS;
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @NotNull
    public static final List<File> findCompilerJar(@NotNull Class<?> classFromJarInTheSameLocation, @NotNull File kotlinHome) {
        List<File> list;
        File[] fileArray;
        File[] fileArray2;
        File[] it;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(classFromJarInTheSameLocation, "classFromJarInTheSameLocation");
        Intrinsics.checkNotNullParameter(kotlinHome, "kotlinHome");
        File[] fileArray3 = FindCompilerKt.tryGetResourcePathForClass(classFromJarInTheSameLocation);
        if (fileArray3 == null) {
            object = null;
        } else {
            File[] fileArray4 = fileArray3;
            boolean bl2 = false;
            bl = false;
            it = fileArray4;
            boolean bl3 = false;
            object = fileArray2 = !it.isDirectory() ? fileArray4 : null;
        }
        fileArray2 = fileArray2 == null ? kotlinHome : ((fileArray3 = fileArray2.getParentFile()) == null ? kotlinHome : fileArray3);
        boolean bl4 = false;
        boolean bl5 = false;
        File[] it2 = fileArray2;
        boolean bl6 = false;
        Object object2 = fileArray = it2.isDirectory() ? fileArray2 : null;
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] baseDir = fileArray;
        fileArray2 = baseDir.listFiles(FindCompilerKt::findCompilerJar$lambda-3);
        if (fileArray2 == null) {
            list = null;
        } else {
            File[] fileArray5 = fileArray2;
            boolean bl7 = false;
            bl = false;
            it = fileArray5;
            boolean bl8 = false;
            File[] fileArray6 = it.length >= COMPILER_JARS.size() ? fileArray5 : null;
            list = fileArray6 == null ? null : ArraysKt.toList(fileArray6);
        }
        List<File> compilerJars = list;
        fileArray2 = compilerJars;
        return fileArray2 == null ? CollectionsKt.emptyList() : fileArray2;
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue(string, "aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null)).append(".class").toString();
        string = FindCompilerKt.getResourceRoot(aClass, path);
        if (string == null) {
            file = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            file = new File(it).getAbsoluteFile();
        }
        return file;
    }

    private static final String getResourceRoot(Class<?> context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            String string = path;
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string3);
        }
        return url != null ? FindCompilerKt.extractRoot(url, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        String string2;
        Pair<String, String> pair;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, '/', false, 2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, '\\', false, 2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual(protocol, FILE_PROTOCOL)) {
            pair = FindCompilerKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull(pair);
            String path = ((File)((Object)pair)).getPath();
            Intrinsics.checkNotNullExpressionValue(path, "path");
            String testPath = StringsKt.replace$default(path, '\\', '/', false, 4, null);
            String testResourcePath = StringsKt.replace$default(resourcePath, '\\', '/', false, 4, null);
            if (StringsKt.endsWith(testPath, testResourcePath, true)) {
                String string3 = path;
                int n = 0;
                int n2 = path.length() - resourcePath.length();
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string4;
            }
        } else if (Intrinsics.areEqual(protocol, JAR_PROTOCOL)) {
            Pair<String, String> paths;
            pair = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue(pair, "resourceURL.file");
            pair = paths = FindCompilerKt.splitJarUrl((String)((Object)pair));
            if ((pair == null ? null : pair.getFirst()) != null) {
                resultPath = new File(paths.getFirst()).getCanonicalPath();
            }
        }
        if ((string2 = resultPath) == null) {
            string = null;
        } else {
            pair = (Pair<String, String>)new char[1];
            pair[0] = (Pair<String, String>)File.separatorChar;
            string = StringsKt.trimEnd(string2, pair);
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block12: {
            Integer n;
            Object object = StringsKt.indexOf$default((CharSequence)url, JAR_SEPARATOR, 0, false, 6, null);
            int n2 = 0;
            int n3 = 0;
            int it = ((Number)object).intValue();
            boolean bl = false;
            Integer n4 = n = it >= 0 ? object : null;
            if (n == null) {
                return null;
            }
            int pivot = n;
            object = url;
            n2 = pivot + 2;
            n3 = 0;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object2).substring(n2);
            Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
            resourcePath = string;
            String string2 = url;
            n3 = 0;
            int n5 = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n3, pivot);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string4;
            if (StringsKt.startsWith$default(jarPath, "jar:", false, 2, null)) {
                string2 = jarPath;
                n3 = JAR_PROTOCOL.length() + 1;
                n5 = 0;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3);
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
                jarPath = string6;
            }
            if (StringsKt.startsWith$default(jarPath, FILE_PROTOCOL, false, 2, null)) {
                try {
                    File file = FindCompilerKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull(file);
                    string2 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue(string2, "URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default(string2, '\\', '/', false, 4, null);
                }
                catch (Exception e) {
                    String string7 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl2 = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n5);
                    Intrinsics.checkNotNullExpressionValue(string9, "(this as java.lang.String).substring(startIndex)");
                    jarPath = string9;
                    if (StringsKt.startsWith$default(jarPath, SCHEME_SEPARATOR, false, 2, null)) {
                        string7 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl2 = false;
                        String string10 = string7;
                        if (string10 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string11 = string10.substring(n5);
                        Intrinsics.checkNotNullExpressionValue(string11, "(this as java.lang.String).substring(startIndex)");
                        jarPath = string11;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, ':', false, 2, null)) break block12;
                    string7 = jarPath;
                    n5 = 1;
                    bl2 = false;
                    String string12 = string7;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(n5);
                    Intrinsics.checkNotNullExpressionValue(string13, "(this as java.lang.String).substring(startIndex)");
                    jarPath = string13;
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    private static final File toFileOrNull(URL $this$toFileOrNull) {
        File file;
        Serializable serializable;
        try {
            serializable = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            serializable = null;
        }
        catch (URISyntaxException e) {
            serializable = null;
        }
        File file2 = serializable;
        if (file2 == null) {
            serializable = $this$toFileOrNull;
            boolean bl = false;
            boolean bl2 = false;
            Serializable $this$toFileOrNull_u24lambda_u2d7 = serializable;
            boolean bl3 = false;
            file = !Intrinsics.areEqual(((URL)$this$toFileOrNull_u24lambda_u2d7).getProtocol(), FILE_PROTOCOL) ? null : new File(((URL)$this$toFileOrNull_u24lambda_u2d7).getFile());
        } else {
            file = file2;
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchMaybeVersionedFile(File $this$matchMaybeVersionedFile, String baseName) {
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), baseName)) return true;
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), StringsKt.removeSuffix(baseName, (CharSequence)".jar"))) return true;
        Regex regex = new Regex(Intrinsics.stringPlus(Regex.Companion.escape(StringsKt.removeSuffix(baseName, (CharSequence)".jar")), "(-\\d.*)?\\.jar"));
        String string = $this$matchMaybeVersionedFile.getName();
        Intrinsics.checkNotNullExpressionValue(string, "name");
        if (!regex.matches(string)) return false;
        return true;
    }

    private static final boolean findCompilerJar$lambda-3(File f) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(f, "f");
            Iterable $this$any$iv = COMPILER_JARS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String expected = (String)element$iv;
                    boolean bl2 = false;
                    if (!(FindCompilerKt.matchMaybeVersionedFile(f, expected) && Intrinsics.areEqual(FilesKt.getExtension(f), JAR_PROTOCOL))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        String[] stringArray = new String[]{"kotlin-compiler", "kotlin-stdlib", "kotlin-reflect"};
        COMPILER_JARS = CollectionsKt.listOf(stringArray);
    }
}

