/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    private Map<K, V> myMap;

    private FactoryMap(boolean safe) {
    }

    @NotNull
    protected Map<K, V> createMap() {
        return new THashMap();
    }

    @Nullable
    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        Object k;
        Map map = this.getMap();
        V value2 = map.get(k = FactoryMap.notNull(key));
        if (value2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = FactoryMap.notNull(value2);
                map.put(k, v);
            }
        }
        return FactoryMap.nullize(value2);
    }

    private Map<K, V> getMap() {
        Map<K, V> map = this.myMap;
        if (map == null) {
            this.myMap = map = this.createMap();
        }
        return map;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? FactoryMap.FAKE_NULL() : key);
    }

    @Nullable
    private static <T> T nullize(T value2) {
        return value2 == FactoryMap.FAKE_NULL() ? null : (T)value2;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getMap().containsKey(FactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value2) {
        Object k = FactoryMap.notNull(key);
        Object v = FactoryMap.notNull(value2);
        v = this.getMap().put(k, v);
        return (V)FactoryMap.nullize(v);
    }

    @Override
    public V remove(Object key) {
        V v = this.getMap().remove(key);
        return FactoryMap.nullize(v);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Object nullKey;
        Set<K> ts = this.getMap().keySet();
        if (ts.contains(nullKey = FactoryMap.FAKE_NULL())) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(nullKey);
            hashSet.add(null);
            HashSet<K> hashSet2 = hashSet;
            if (hashSet2 == null) {
                FactoryMap.$$$reportNull$$$0(0);
            }
            return hashSet2;
        }
        Set<K> set = ts;
        if (set == null) {
            FactoryMap.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.getMap().containsValue(value2);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            FactoryMap.$$$reportNull$$$0(2);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        List<Object> list2 = ContainerUtil.map(this.getMap().values(), FactoryMap::nullize);
        if (list2 == null) {
            FactoryMap.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = ContainerUtil.map2Set(this.getMap().entrySet(), entry -> new AbstractMap.SimpleEntry(FactoryMap.nullize(entry.getKey()), FactoryMap.nullize(entry.getValue())));
        if (set == null) {
            FactoryMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    public String toString() {
        return String.valueOf(this.myMap);
    }

    @NotNull
    public static <K, V> Map<K, V> create(final @NotNull Function<? super K, ? extends V> computeValue) {
        if (computeValue == null) {
            FactoryMap.$$$reportNull$$$0(5);
        }
        return new FactoryMap<K, V>(true){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FactoryMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FactoryMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

