/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.Interner;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "()V", "canonicalNameInterner", "Lcom/intellij/util/containers/Interner;", "", "mapAsmType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "parseClassOrTypeVariableElement", "signature", "Ljava/text/CharacterIterator;", "parseClassifierRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseDimensions", "", "parseParameterizedClassRefSignature", "parsePrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "parseTypeParameter", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "parseTypeParametersDeclaration", "", "parseTypeString", "parseTypeVariableRefSignature", "parseTypeWithoutVarianceAndArray", "parseVariance", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "ClsFormatException", "JavaSignatureVariance", "resolution.common.jvm"})
public final class BinaryClassSignatureParser {
    @NotNull
    private final Interner<String> canonicalNameInterner = PlatformUtilsKt.createStringInterner();

    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (signature2.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        boolean bl = false;
        ArrayList<JavaTypeParameter> typeParameters2 = new ArrayList<JavaTypeParameter>();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(this.parseTypeParameter(signature2, context2));
        }
        signature2.next();
        return CollectionsKt.compact(typeParameters2);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature2, ClassifierResolutionContext context2) {
        Object object;
        StringBuilder name = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        String string2 = name.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.toString()");
        String parameterName = string2;
        List bounds = new SmartList();
        boolean hasImplicitObjectBound = false;
        while (signature2.current() == ':') {
            signature2.next();
            if (signature2.current() == ':') {
                hasImplicitObjectBound = true;
                continue;
            }
            object = this.parseClassifierRefSignature(signature2, context2);
            if (object == null) continue;
            bounds.add(object);
        }
        object = Name.identifier(parameterName);
        Intrinsics.checkNotNullExpressionValue(object, "identifier(parameterName)");
        return new BinaryJavaTypeParameter((Name)object, bounds, hasImplicitObjectBound);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        char c = signature2.current();
        return c == 'L' ? this.parseParameterizedClassRefSignature(signature2, context2) : (c == 'T' ? this.parseTypeVariableRefSignature(signature2, context2) : null);
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature2, ClassifierResolutionContext context2) {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        String string2 = this.canonicalNameInterner.intern(id.toString());
        Intrinsics.checkNotNullExpressionValue(string2, "canonicalNameInterner.intern(id.toString())");
        String parameterName = string2;
        return new PlainJavaClassifierType(new Function0<ClassifierResolutionContext.Result>(context2, parameterName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $parameterName;
            {
                this.$context = $context;
                this.$parameterName = $parameterName;
                super(0);
            }

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveTypeParameter$resolution_common_jvm(this.$parameterName);
            }
        }, kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature2, ClassifierResolutionContext context2) {
        StringBuilder canonicalName = new StringBuilder();
        SmartList<List> argumentGroups = new SmartList<List>();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c = signature2.current();
            if (c == '<') {
                boolean bl = false;
                List group = new ArrayList();
                signature2.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature2, context2));
                } while (signature2.current() != '>');
                argumentGroups.add(group);
            } else if (c != ' ') {
                canonicalName.append(c);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        signature2.next();
        String string2 = canonicalName.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "canonicalName.toString()");
        String string3 = this.canonicalNameInterner.intern(StringsKt.replace$default(string2, '.', '$', false, 4, null));
        Intrinsics.checkNotNullExpressionValue(string3, "canonicalNameInterner.intern(canonicalName.toString().replace('.', '$'))");
        String internalName2 = string3;
        boolean bl = false;
        return new PlainJavaClassifierType(new Function0<ClassifierResolutionContext.Result>(context2, internalName2){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $internalName;
            {
                this.$context = $context;
                this.$internalName = $internalName;
                super(0);
            }

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveByInternalName$resolution_common_jvm(this.$internalName);
            }
        }, CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(kotlin.collections.CollectionsKt.reversed((Iterable)argumentGroups), (Collection)new ArrayList())));
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature2, ClassifierResolutionContext context2) {
        JavaSignatureVariance variance = this.parseVariance(signature2);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type2 = this.parseTypeString(signature2, context2);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type2;
        }
        return new PlainJavaWildcardType(type2, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature2) {
        JavaSignatureVariance variance;
        JavaSignatureVariance javaSignatureVariance;
        boolean advance = true;
        char c = signature2.current();
        if (c == '+') {
            javaSignatureVariance = JavaSignatureVariance.PLUS;
        } else if (c == '-') {
            javaSignatureVariance = JavaSignatureVariance.MINUS;
        } else if (c == '*') {
            javaSignatureVariance = JavaSignatureVariance.STAR;
        } else if (c == '.' ? true : c == '=') {
            javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
        } else {
            advance = false;
            javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
        }
        if (advance) {
            signature2.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            int n = dimensions;
            dimensions = n + 1;
            signature2.next();
        }
        return dimensions;
    }

    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        int dimensions = this.parseDimensions(signature2);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature2, context2);
        if (javaType == null) {
            throw new ClsFormatException(null, null, 3, null);
        }
        JavaType type2 = javaType;
        Iterable $this$fold$iv = new IntRange(1, dimensions);
        boolean $i$f$fold = false;
        JavaType accumulator$iv = type2;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int n = element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.parseTypeString(new StringCharacterIterator(type2.getDescriptor()), context2);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature2, ClassifierResolutionContext context2) {
        char c = signature2.current();
        return c == 'L' ? (JavaType)this.parseParameterizedClassRefSignature(signature2, context2) : (c == 'T' ? (JavaType)this.parseTypeVariableRefSignature(signature2, context2) : (c == 'B' ? this.parsePrimitiveType(signature2, PrimitiveType.BYTE) : (c == 'C' ? this.parsePrimitiveType(signature2, PrimitiveType.CHAR) : (c == 'D' ? this.parsePrimitiveType(signature2, PrimitiveType.DOUBLE) : (c == 'F' ? this.parsePrimitiveType(signature2, PrimitiveType.FLOAT) : (c == 'I' ? this.parsePrimitiveType(signature2, PrimitiveType.INT) : (c == 'J' ? this.parsePrimitiveType(signature2, PrimitiveType.LONG) : (c == 'Z' ? this.parsePrimitiveType(signature2, PrimitiveType.BOOLEAN) : (c == 'S' ? this.parsePrimitiveType(signature2, PrimitiveType.SHORT) : (c == 'V' ? this.parsePrimitiveType(signature2, null) : null))))))))));
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature2, PrimitiveType primitiveType) {
        signature2.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE", "resolution.common.jvm"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance MINUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance STAR = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE = new JavaSignatureVariance();
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String value2) {
            return Enum.valueOf(JavaSignatureVariance.class, value2);
        }

        static {
            $VALUES = javaSignatureVarianceArray = new JavaSignatureVariance[]{JavaSignatureVariance.PLUS, JavaSignatureVariance.MINUS, JavaSignatureVariance.STAR, JavaSignatureVariance.NO_VARIANCE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "resolution.common.jvm"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message2, @Nullable Throwable cause) {
            super(message2, cause);
        }

        public /* synthetic */ ClsFormatException(String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string2, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }
}

