/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkIdentifier", "identifier", "Lcom/intellij/psi/PsiElement;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "allowSingleUnderscore", "", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "frontend"})
public final class UnderscoreChecker
implements DeclarationChecker {
    @NotNull
    public static final UnderscoreChecker INSTANCE = new UnderscoreChecker();

    private UnderscoreChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (identifier == null) return;
        CharSequence charSequence = identifier.getText();
        Intrinsics.checkNotNullExpressionValue(charSequence, "identifier.text");
        charSequence = charSequence;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        boolean bl3 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual(identifier.getText(), "_");
        if (!isValidSingleUnderscore) {
            boolean bl4;
            block5: {
                String string2 = identifier.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "identifier.text");
                CharSequence $this$all$iv = string2;
                boolean $i$f$all = false;
                CharSequence charSequence2 = $this$all$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence2.charAt(i);
                    boolean bl5 = false;
                    if (it == '_') continue;
                    bl4 = false;
                    break block5;
                }
                bl4 = true;
            }
            if (bl4) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, TuplesKt.to(LanguageFeature.SingleUnderscoreForParameterName, languageVersionSettings)));
    }

    public static /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings, bl);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.checkIdentifier(declaration2.getNameIdentifier(), diagnosticHolder, languageVersionSettings, allowSingleUnderscore);
    }

    public static /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, bl);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (declaration2 instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            for (KtParameter parameter : ((KtCallableDeclaration)declaration2).getValueParameters()) {
                Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                this.checkNamed(parameter, context2.getTrace(), context2.getLanguageVersionSettings(), descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration2).getTypeParameters()) {
                Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                UnderscoreChecker.checkNamed$default(this, typeParameter, context2.getTrace(), context2.getLanguageVersionSettings(), false, 8, null);
            }
        }
        if (!(declaration2 instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration2, context2.getTrace(), context2.getLanguageVersionSettings(), false, 8, null);
    }

    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        UnderscoreChecker.checkNamed$default(this, declaration2, diagnosticHolder, languageVersionSettings, false, 8, null);
    }
}

